/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskProvider;
import org.nuxeo.ecm.platform.task.TaskQueryConstant;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;
import org.nuxeo.ecm.platform.task.core.service.TaskEventNotificationHelper;

public class DocumentTaskProvider
implements TaskProvider {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentTaskProvider.class);

    public List<Task> getCurrentTaskInstances(CoreSession coreSession) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)coreSession.getPrincipal();
        List<String> actors = TaskActorsHelper.getTaskActors(principal);
        return this.getCurrentTaskInstances(actors, coreSession);
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession) throws ClientException {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        String userNames = TaskQueryConstant.formatStringList(actors);
        String query = String.format("SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:actors IN (%s) ", userNames);
        return this.queryTasksUnrestricted(query, coreSession);
    }

    public List<Task> getTaskInstances(DocumentModel dm, NuxeoPrincipal user, CoreSession coreSession) throws ClientException {
        String query;
        if (user == null) {
            query = String.format("SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:targetDocumentId = '%s'", dm.getId());
        } else {
            List<String> actors = TaskActorsHelper.getTaskActors(user);
            String userNames = TaskQueryConstant.formatStringList(actors);
            query = String.format("SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:targetDocumentId = '%s' AND nt:actors IN (%s) ", dm.getId(), userNames);
        }
        return this.queryTasksUnrestricted(query, coreSession);
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, CoreSession coreSession) throws ClientException {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        String userNames = TaskQueryConstant.formatStringList(actors);
        String query = String.format("SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:targetDocumentId = '%s' AND nt:actors IN (%s) ", dm.getId(), userNames);
        return this.queryTasksUnrestricted(query, coreSession);
    }

    public List<Task> getAllTaskInstances(String processId, CoreSession session) throws ClientException {
        String query = String.format("SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:processId = '%s' ", processId);
        return this.queryTasksUnrestricted(query, session);
    }

    public List<Task> getAllTaskInstances(String processId, NuxeoPrincipal user, CoreSession session) throws ClientException {
        List<String> actors = TaskActorsHelper.getTaskActors(user);
        return this.getAllTaskInstances(processId, actors, session);
    }

    public List<Task> getAllTaskInstances(String processId, List<String> actors, CoreSession session) throws ClientException {
        String userNames = TaskQueryConstant.formatStringList(actors);
        String query = String.format("SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:processId = '%s' AND nt:actors IN (%s) ", processId, userNames);
        return this.queryTasksUnrestricted(query, session);
    }

    protected List<Task> queryTasksUnrestricted(final String query, CoreSession session) throws ClientException {
        final ArrayList<Task> tasks = new ArrayList<Task>();
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                DocumentModelList taskDocuments = this.session.query(query);
                tasks.addAll(DocumentTaskProvider.wrapDocModelInTask(taskDocuments, true));
            }
        }.runUnrestricted();
        return tasks;
    }

    public static List<Task> wrapDocModelInTask(DocumentModelList taskDocuments) throws ClientException {
        return DocumentTaskProvider.wrapDocModelInTask(taskDocuments, false);
    }

    public static List<Task> wrapDocModelInTask(DocumentModelList taskDocuments, boolean detach) throws ClientException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (DocumentModel doc : taskDocuments) {
            if (detach) {
                doc.detach(true);
            }
            tasks.add((Task)doc.getAdapter(Task.class));
        }
        return tasks;
    }

    public String endTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment, String eventName, boolean isValidated) throws ClientException {
        if (!StringUtils.isEmpty((String)comment)) {
            task.addComment(principal.getName(), comment);
        }
        task.setVariable(TaskService.VariableName.validated.name(), String.valueOf(isValidated));
        task.end(coreSession);
        coreSession.saveDocument(task.getDocument());
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        ArrayList<String> notificationRecipients = new ArrayList<String>();
        notificationRecipients.add(task.getInitiator());
        notificationRecipients.addAll(task.getActors());
        eventProperties.put("recipients", notificationRecipients);
        DocumentModel document = null;
        String docId = task.getVariable(TaskService.VariableName.documentId.name());
        String docRepo = task.getVariable(TaskService.VariableName.documentRepositoryName.name());
        if (coreSession.getRepositoryName().equals(docRepo)) {
            try {
                document = coreSession.getDocument((DocumentRef)new IdRef(docId));
            }
            catch (Exception e) {
                log.error((Object)String.format("Could not fetch document with id '%s:%s' for notification", docRepo, docId), (Throwable)e);
            }
        } else {
            log.error((Object)String.format("Could not resolve document for notification: document is on repository '%s' and given session is on repository '%s'", docRepo, coreSession.getRepositoryName()));
        }
        TaskEventNotificationHelper.notifyEvent(coreSession, document, principal, task, eventName, eventProperties, comment, null);
        String seamEventName = isValidated ? "workflowTaskCompleted" : "workflowTaskRejected";
        return seamEventName;
    }
}

