/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.dashboard;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.helper.WebContentHelper;
import org.nuxeo.opensocial.container.shared.layout.api.LayoutHelper;
import org.nuxeo.opensocial.container.shared.layout.enume.YUITemplate;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractDashboardSpaceCreator
extends UnrestrictedSessionRunner {
    public static final String DASHBOARD_MANAGEMENT_NAME = "dashboard-management";
    public static final String DASHBOARD_MANAGEMENT_PATH = "/management/dashboard-management";
    public static final String DASHBOARD_MANAGEMENT_TYPE = "HiddenFolder";
    protected Map<String, String> parameters = new HashMap<String, String>();

    protected AbstractDashboardSpaceCreator(CoreSession session, Map<String, String> parameters) {
        super(session);
        this.parameters = parameters;
    }

    protected DocumentModel getDashboardManagement() throws ClientException {
        String dashboardManagementPath = new Path("/management").append(DASHBOARD_MANAGEMENT_NAME).toString();
        PathRef dashboardManagementPathRef = new PathRef(dashboardManagementPath);
        if (!this.session.exists((DocumentRef)dashboardManagementPathRef)) {
            DocumentModel dashboardManagement = this.session.createDocumentModel("/management", DASHBOARD_MANAGEMENT_NAME, DASHBOARD_MANAGEMENT_TYPE);
            return this.session.createDocument(dashboardManagement);
        }
        return this.session.getDocument((DocumentRef)dashboardManagementPathRef);
    }

    protected void addInitialGadgets(DocumentModel anonymousDashboardSpace) throws ClientException {
        Space space = (Space)anonymousDashboardSpace.getAdapter(Space.class);
        this.initializeLayout(space);
        String userLanguage = this.parameters.get("userLanguage");
        Locale locale = userLanguage != null ? new Locale(userLanguage) : null;
        this.initializeGadgets(space, this.session, locale);
    }

    protected void initializeLayout(Space space) throws ClientException {
        space.initLayout(LayoutHelper.buildLayout((YUITemplate[])new YUITemplate[]{YUITemplate.YUI_ZT_50_50, YUITemplate.YUI_ZT_50_50, YUITemplate.YUI_ZT_50_50}));
    }

    protected void initializeGadgets(Space space, CoreSession session, Locale locale) throws ClientException {
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"userworkspaces", (int)0, (int)0, (int)0);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"userdocuments", (int)0, (int)0, (int)1);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"lastdocuments", (int)0, (int)0, (int)2);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"quicksearch", (int)0, (int)1, (int)0);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"tasks", (int)0, (int)1, (int)2);
    }

    protected UserManager getUserManager() throws ClientException {
        try {
            return (UserManager)Framework.getService(UserManager.class);
        }
        catch (Exception e) {
            throw new ClientException("Unable to retrieve UserManager service", (Throwable)e);
        }
    }
}

