/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth.providers.NuxeoOAuthServiceProvider;
import org.nuxeo.ecm.platform.oauth.providers.OAuthServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuthServiceProviderRegistryImpl
extends DefaultComponent
implements OAuthServiceProviderRegistry {
    protected static final Log log = LogFactory.getLog(OAuthServiceProviderRegistryImpl.class);
    public static final String DIRECTORY_NAME = "oauthServiceProviders";
    protected Map<String, NuxeoOAuthServiceProvider> inMemoryProviders = new HashMap<String, NuxeoOAuthServiceProvider>();

    @Override
    public NuxeoOAuthServiceProvider getProvider(String gadgetUri, String serviceName) {
        try {
            NuxeoOAuthServiceProvider provider = this.getEntry(gadgetUri, serviceName, null);
            return provider;
        }
        catch (Exception e) {
            log.error((Object)"Unable to read provider from Directory backend", (Throwable)e);
            return null;
        }
    }

    protected String getBareGadgetUri(String gadgetUri) {
        if (gadgetUri == null) {
            return null;
        }
        String pattern = "http(s)?://(localhost|127.0.0.1)";
        return gadgetUri.replaceFirst(pattern, "");
    }

    protected String preProcessServiceName(String serviceName) {
        if (serviceName != null && serviceName.trim().isEmpty()) {
            return null;
        }
        return serviceName;
    }

    protected DocumentModel getBestEntry(DocumentModelList entries, String gadgetUri, String serviceName) throws PropertyException, ClientException {
        if (entries.size() > 1) {
            log.warn((Object)("Found several entries for gadgetUri=" + gadgetUri + " and serviceName=" + serviceName));
        }
        if (serviceName == null || serviceName.trim().isEmpty()) {
            for (DocumentModel entry : entries) {
                if (entry.getPropertyValue("serviceName") != null && !((String)((Object)entry.getPropertyValue("serviceName"))).trim().isEmpty()) continue;
                return entry;
            }
            return null;
        }
        if (gadgetUri == null || gadgetUri.trim().isEmpty()) {
            for (DocumentModel entry : entries) {
                if (entry.getPropertyValue("gadgetUrl") != null && !((String)((Object)entry.getPropertyValue("gadgetUrl"))).trim().isEmpty()) continue;
                return entry;
            }
            return null;
        }
        return (DocumentModel)entries.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NuxeoOAuthServiceProvider getEntry(String gadgetUri, String serviceName, Set<String> ftFilter) throws Exception {
        String id = this.mkStringIdx(gadgetUri, serviceName);
        if (this.inMemoryProviders.containsKey(id)) {
            return this.inMemoryProviders.get(id);
        }
        serviceName = this.preProcessServiceName(serviceName);
        if (gadgetUri == null && serviceName == null) {
            log.warn((Object)"Can not find provider with null gadgetUri and null serviceName !");
            return null;
        }
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        Session session = null;
        NuxeoOAuthServiceProvider provider = null;
        try {
            DocumentModelList entries;
            session = ds.open(DIRECTORY_NAME);
            HashMap<String, String> filter = new HashMap<String, String>();
            if (gadgetUri != null) {
                filter.put("gadgetUrl", gadgetUri);
            }
            if (serviceName != null) {
                filter.put("serviceName", serviceName);
            }
            if ((entries = session.query(filter, ftFilter)) == null || entries.size() == 0) {
                String bareGadgetUrl = this.getBareGadgetUri(gadgetUri);
                if (bareGadgetUrl != null && !bareGadgetUrl.equals(gadgetUri)) {
                    HashSet<String> urlfilter = new HashSet<String>();
                    urlfilter.add("gadgetUrl");
                    NuxeoOAuthServiceProvider nuxeoOAuthServiceProvider = this.getEntry(bareGadgetUrl, serviceName, urlfilter);
                    return nuxeoOAuthServiceProvider;
                }
                if (serviceName != null) {
                    if (bareGadgetUrl != null && (provider = this.getEntry(bareGadgetUrl, null, ftFilter)) != null) {
                        NuxeoOAuthServiceProvider nuxeoOAuthServiceProvider = provider;
                        return nuxeoOAuthServiceProvider;
                    }
                    if (gadgetUri != null) {
                        NuxeoOAuthServiceProvider nuxeoOAuthServiceProvider = this.getEntry(null, serviceName, ftFilter);
                        return nuxeoOAuthServiceProvider;
                    }
                }
                NuxeoOAuthServiceProvider nuxeoOAuthServiceProvider = null;
                return nuxeoOAuthServiceProvider;
            }
            DocumentModel entry = this.getBestEntry(entries, gadgetUri, serviceName);
            if (entry == null) {
                NuxeoOAuthServiceProvider nuxeoOAuthServiceProvider = null;
                return nuxeoOAuthServiceProvider;
            }
            NuxeoOAuthServiceProvider nuxeoOAuthServiceProvider = provider = NuxeoOAuthServiceProvider.createFromDirectoryEntry(entry);
            return nuxeoOAuthServiceProvider;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected String mkStringIdx(String gadgetUri, String serviceName) {
        return "k-" + gadgetUri + "-" + serviceName;
    }

    @Override
    public NuxeoOAuthServiceProvider addReadOnlyProvider(String gadgetUri, String serviceName, String consumerKey, String consumerSecret, String publicKey) {
        String id = this.mkStringIdx(gadgetUri, serviceName);
        Long dummyId = new Random().nextLong();
        NuxeoOAuthServiceProvider sp = new NuxeoOAuthServiceProvider(dummyId, gadgetUri, serviceName, consumerKey, consumerSecret, publicKey);
        this.inMemoryProviders.put(id, sp);
        return sp;
    }

    @Override
    public void deleteProvider(String gadgetUri, String serviceName) {
        NuxeoOAuthServiceProvider provider = this.getProvider(gadgetUri, serviceName);
        if (provider != null) {
            this.deleteProvider(provider.id.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProvider(String providerId) {
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            Session session = null;
            try {
                session = ds.open(DIRECTORY_NAME);
                session.deleteEntry(providerId);
                session.commit();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to delete provider " + providerId), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NuxeoOAuthServiceProvider> listProviders() {
        ArrayList<NuxeoOAuthServiceProvider> result = new ArrayList<NuxeoOAuthServiceProvider>();
        for (NuxeoOAuthServiceProvider provider : this.inMemoryProviders.values()) {
            result.add(provider);
        }
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            Session session = null;
            try {
                session = ds.open(DIRECTORY_NAME);
                DocumentModelList entries = session.getEntries();
                for (DocumentModel entry : entries) {
                    result.add(NuxeoOAuthServiceProvider.createFromDirectoryEntry(entry));
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while fetching provider directory", (Throwable)e);
        }
        return result;
    }
}

