/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.cache.CacheManagerAware;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.session.mgt.AbstractValidatingSessionManager;
import org.jsecurity.session.mgt.SimpleSession;
import org.jsecurity.session.mgt.eis.MemorySessionDAO;
import org.jsecurity.session.mgt.eis.SessionDAO;
import org.jsecurity.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSessionManager
extends AbstractValidatingSessionManager
implements CacheManagerAware {
    private static final Log log = LogFactory.getLog(DefaultSessionManager.class);
    protected SessionDAO sessionDAO = new MemorySessionDAO();

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }

    public SessionDAO getSessionDAO() {
        return this.sessionDAO;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        ((CacheManagerAware)((Object)this.getSessionDAO())).setCacheManager(cacheManager);
    }

    @Override
    protected Session doCreateSession(InetAddress originatingHost) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating session for originating host [" + originatingHost + "]"));
        }
        Session s = this.newSessionInstance(originatingHost);
        this.create(s);
        return s;
    }

    protected Session newSessionInstance(InetAddress inetAddress) {
        return new SimpleSession(inetAddress);
    }

    protected void create(Session session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new EIS record for new session instance [" + session + "]"));
        }
        this.sessionDAO.create(session);
    }

    @Override
    protected void onStop(Session session) {
        if (session instanceof SimpleSession) {
            Date stopTs = ((SimpleSession)session).getStopTimestamp();
            ((SimpleSession)session).setLastAccessTime(stopTs);
        }
        super.onStop(session);
    }

    @Override
    protected void onExpiration(Session session) {
        if (session instanceof SimpleSession) {
            ((SimpleSession)session).setExpired(true);
        }
        this.onChange(session);
    }

    @Override
    protected void onChange(Session session) {
        this.sessionDAO.update(session);
    }

    @Override
    protected Session retrieveSession(Serializable sessionId) throws InvalidSessionException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Retrieving session with id [" + sessionId + "]"));
        }
        Session s = this.sessionDAO.readSession(sessionId);
        this.validate(s);
        return s;
    }

    @Override
    protected Collection<Session> getActiveSessions() {
        Collection<Session> active = this.sessionDAO.getActiveSessions();
        return active != null ? active : CollectionUtils.emptyCollection(Session.class);
    }
}

