/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.dashboard;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;
import org.nuxeo.ecm.platform.task.dashboard.AbstractDashBoardItemImpl;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItem;

public class DashBoardItemImpl
extends AbstractDashBoardItemImpl
implements DashBoardItem {
    private static final long serialVersionUID = 919752175741886376L;
    protected final String id;
    protected final String name;
    protected final String description;
    protected final Date startDate;
    protected final Date dueDate;
    protected final boolean expired;
    protected final String directive;
    protected final DocumentModel document;
    protected final Task task;
    protected String comment;

    public DashBoardItemImpl(Task task, Locale locale) {
        this(task, task.getDocument(), locale);
    }

    public DashBoardItemImpl(Task task, DocumentModel document, Locale locale) {
        try {
            this.task = task;
            this.document = document;
            this.locale = locale;
            this.id = task.getId();
            this.name = task.getName();
            this.description = task.getDescription();
            this.dueDate = task.getDueDate();
            this.startDate = task.getCreated();
            this.directive = task.getDirective();
            List<TaskComment> comments = task.getComments();
            this.comment = comments != null && !comments.isEmpty() ? comments.get(comments.size() - 1).getText() : null;
            if (this.dueDate != null) {
                Date today = new Date();
                this.expired = this.dueDate.before(today);
            } else {
                this.expired = false;
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DocumentRef getDocRef() {
        return this.document.getRef();
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDirective() {
        return this.directive;
    }

    @Override
    public DocumentModel getDocument() {
        return this.document;
    }

    @Override
    public boolean isExpired() {
        return this.expired;
    }

    @Override
    public Task getTask() {
        return this.task;
    }
}

