/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;

@Operation(id="Context.RunOperationOnList", category="Execution Flow", label="Run For Each", description="Run an operation for each element from the list defined by the 'list' paramter. The 'list' parameter is pointing to context variable that represent the list which will be iterated. The 'item' parameter represent the name of the context varible which will point to the current element in the list at each iteration. You can use the 'isolate' parameter to specify whether or not the evalution context is the same as the parent context or a copy of it. If the isolate is 'true' then a copy of the current contetx is used and so that modifications in this context will not affect the parent context. Any input is accepted. The input is returned back as output when operation terminate.")
public class RunOperationOnList {
    public static final String ID = "Context.RunOperationOnList";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="list")
    protected String listName;
    @Param(name="item", required=false, values={"item"})
    protected String itemName = "item";
    @Param(name="isolate", required=false, values={"true"})
    protected boolean isolate = true;

    @OperationMethod
    public void run() throws Exception {
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        OperationContext subctx = new OperationContext(this.ctx.getCoreSession(), vars);
        subctx.setInput(this.ctx.getInput());
        for (Object value : (Collection)this.ctx.get(this.listName)) {
            subctx.put(this.itemName, value);
            this.service.run(subctx, this.chainId);
        }
    }
}

