/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.search;

import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public final class FieldHelper {
    private FieldHelper() {
    }

    public static String getPrefixedName(String fullName) {
        if (fullName == null) {
            return null;
        }
        if (fullName.startsWith("ecm:")) {
            return fullName;
        }
        int colonIndex = fullName.indexOf(58);
        String schemaName = fullName.substring(0, colonIndex);
        String fieldName = fullName.substring(colonIndex + 1);
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = schemaManager.getSchema(schemaName);
        if (schema == null) {
            return null;
        }
        Field field = schema.getField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getName().getPrefixedName();
    }

    public static String getFullName(String prefixedName) {
        if (prefixedName == null) {
            return null;
        }
        if (prefixedName.startsWith("ecm:")) {
            return prefixedName;
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Field field = schemaManager.getField(prefixedName);
        String schema = field.getDeclaringType().getName();
        String name = field.getName().getLocalName();
        return schema + ':' + name;
    }
}

