/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.repository.RepositoryDescriptor;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.security.SecurityManager;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryGarbageCollector;
import org.nuxeo.ecm.core.storage.sql.ConnectionSpecImpl;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSecurityManager;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.ecm.core.storage.sql.net.MapperClientInfo;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionManagerImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionRequestInfoImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionFactoryImpl;
import org.nuxeo.runtime.api.Framework;

public class ConnectionFactoryImpl
implements Repository,
org.nuxeo.ecm.core.model.Repository {
    private static final long serialVersionUID = 1L;
    private final ManagedConnectionFactoryImpl managedConnectionFactory;
    private final ConnectionManager connectionManager;
    private final String name;
    private SecurityManager securityManager;
    private SchemaManager schemaManager;
    private Reference reference;
    private final boolean managed;
    private boolean servicesInitialized;

    public ConnectionFactoryImpl(ManagedConnectionFactoryImpl managedConnectionFactory, ConnectionManager connectionManager) {
        this.managedConnectionFactory = managedConnectionFactory;
        this.connectionManager = connectionManager;
        this.managed = !(connectionManager instanceof ConnectionManagerImpl);
        this.name = managedConnectionFactory.getName();
    }

    public ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    protected void initializeServices() {
        if (!this.servicesInitialized) {
            this.servicesInitialized = true;
            try {
                RepositoryDescriptor descriptor;
                RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
                if (repositoryService != null && (descriptor = repositoryService.getRepositoryManager().getDescriptor(this.name)).getSecurityManagerClass() != null) {
                    this.securityManager = descriptor.getSecurityManager();
                }
                if (this.securityManager == null) {
                    this.securityManager = new SQLSecurityManager();
                }
                this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Session getConnection() throws StorageException {
        ConnectionRequestInfoImpl connectionRequestInfo = new ConnectionRequestInfoImpl();
        try {
            return (Session)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, (ConnectionRequestInfo)connectionRequestInfo);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (ResourceException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Session getConnection(ConnectionSpec connectionSpec) throws StorageException {
        assert (connectionSpec instanceof ConnectionSpecImpl);
        ConnectionRequestInfoImpl connectionRequestInfo = new ConnectionRequestInfoImpl((ConnectionSpecImpl)connectionSpec);
        try {
            return (Session)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, (ConnectionRequestInfo)connectionRequestInfo);
        }
        catch (StorageException e) {
            throw e;
        }
        catch (ResourceException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public void close() throws StorageException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getName() {
        return this.name;
    }

    public org.nuxeo.ecm.core.model.Session getSession(Map<String, Serializable> context) throws DocumentException {
        Session session;
        ConnectionSpecImpl connectionSpec;
        if (context == null) {
            connectionSpec = null;
        } else {
            NuxeoPrincipal principal = (NuxeoPrincipal)context.get("principal");
            String username = principal == null ? (String)((Object)context.get("username")) : principal.getName();
            connectionSpec = new ConnectionSpecImpl(new Credentials(username, null));
        }
        try {
            session = this.getConnection((ConnectionSpec)connectionSpec);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)e);
        }
        return new SQLSession(session, (org.nuxeo.ecm.core.model.Repository)this, context);
    }

    public SecurityManager getNuxeoSecurityManager() {
        this.initializeServices();
        return this.securityManager;
    }

    public SchemaManager getTypeManager() {
        this.initializeServices();
        return this.schemaManager;
    }

    public void initialize() {
    }

    public synchronized org.nuxeo.ecm.core.model.Session[] getOpenedSessions() {
        return new org.nuxeo.ecm.core.model.Session[0];
    }

    public void shutdown() {
        this.managedConnectionFactory.shutdown();
    }

    public int getStartedSessionsCount() {
        return 0;
    }

    public int getClosedSessionsCount() {
        return 0;
    }

    public int getActiveSessionsCount() {
        return this.managedConnectionFactory.getActiveSessionsCount();
    }

    public int clearCaches() {
        return this.managedConnectionFactory.clearCaches();
    }

    public void processClusterInvalidationsNext() {
        this.managedConnectionFactory.processClusterInvalidationsNext();
    }

    public BinaryGarbageCollector getBinaryGarbageCollector() {
        return this.managedConnectionFactory.getBinaryGarbageCollector();
    }

    public void markReferencedBinaries(BinaryGarbageCollector gc) {
        this.managedConnectionFactory.markReferencedBinaries(gc);
    }

    public boolean supportsTags() {
        return true;
    }

    public void activateServer() {
        this.managedConnectionFactory.activateServer();
    }

    public void deactivateServer() {
        this.managedConnectionFactory.deactivateServer();
    }

    public Collection<MapperClientInfo> getClientInfos() {
        return this.managedConnectionFactory.getClientInfos();
    }

    public boolean isServerActivated() {
        return this.managedConnectionFactory.isServerActivated();
    }

    public String getServerURL() {
        return this.managedConnectionFactory.getServerURL();
    }
}

