/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.dashboard;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractDashBoardItemImpl
implements DashBoardItem {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(AbstractDashBoardItemImpl.class);
    protected Locale locale;

    protected String getI18nLabel(String label, Locale locale) {
        if (label == null) {
            label = "";
        }
        if (locale == null) {
            return label;
        }
        return I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)locale);
    }

    @Override
    public String getI18nTaskName() {
        if (this.locale == null || !this.needi18n()) {
            return this.getName();
        }
        String labelKey = "label.workflow.task." + this.getName();
        return this.getI18nLabel(labelKey, this.locale);
    }

    @Override
    public String getI18nDirective() {
        String newdirectiveLabel;
        String directiveKey = this.getDirective();
        if (directiveKey == null) {
            directiveKey = this.getName();
        }
        if (this.locale == null || !this.needi18n()) {
            return directiveKey;
        }
        String directiveLabel = this.getI18nLabel(directiveKey, this.locale);
        if (directiveKey != null && directiveKey.equals(directiveLabel) && !(directiveKey = "label.workflow.task." + directiveKey).equals(newdirectiveLabel = this.getI18nLabel(directiveKey, this.locale))) {
            directiveLabel = newdirectiveLabel;
        }
        return directiveLabel;
    }

    protected boolean isCreatedFromCreateTaskOperation() throws ClientException {
        return Boolean.parseBoolean(this.getTask().getVariable("createdFromCreateTaskOperation"));
    }

    protected boolean needi18n() {
        try {
            if (this.isCreatedFromCreateTaskOperation()) {
                return false;
            }
            return Boolean.parseBoolean(this.getTask().getVariable(Task.TaskVariableName.needi18n.name()));
        }
        catch (Exception e) {
            log.error((Object)"Error while testing Task variables", (Throwable)e);
            return false;
        }
    }

    @Override
    public JSONObject asJSON() throws ClientException {
        boolean createdFromCreateTaskOperation = this.isCreatedFromCreateTaskOperation();
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)this.getTask().getId());
        obj.put((Object)"docref", (Object)this.getDocument().getRef().toString());
        obj.put((Object)"name", (Object)this.getName());
        obj.put((Object)"taskName", (Object)this.getI18nTaskName());
        obj.put((Object)"directive", (Object)this.getI18nDirective());
        String comment = this.getComment();
        obj.put((Object)"comment", (Object)(comment != null ? comment : ""));
        Date dueDate = this.getDueDate();
        obj.put((Object)"dueDate", (Object)(dueDate != null ? DateParser.formatW3CDateTime((Date)dueDate) : ""));
        obj.put((Object)"documentTitle", (Object)this.getDocument().getTitle());
        obj.put((Object)"documentLink", (Object)this.getDocumentLink(false));
        Date startDate = this.getStartDate();
        obj.put((Object)"startDate", (Object)(startDate != null ? DateParser.formatW3CDateTime((Date)startDate) : ""));
        boolean expired = false;
        if (dueDate != null) {
            expired = dueDate.before(new Date());
        }
        obj.put((Object)"expired", (Object)expired);
        return obj;
    }

    @Override
    public String getDocumentLink(boolean includeWorkflowTab) throws ClientException {
        DocumentModel doc = this.getDocument();
        DocumentViewCodecManager documentViewCodecManager = (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
        if (documentViewCodecManager != null) {
            String viewId = this.getDefaultViewFor(doc);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (includeWorkflowTab) {
                parameters.put("tabId", "TAB_CONTENT_JBPM");
            }
            DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(doc), viewId, parameters);
            return documentViewCodecManager.getUrlFromDocumentView("docpath", (DocumentView)docView, false, null);
        }
        return "";
    }

    protected String getDefaultViewFor(DocumentModel doc) {
        TypeInfo type = (TypeInfo)doc.getAdapter(TypeInfo.class);
        if (type == null) {
            return null;
        }
        return type.getDefaultView();
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

