/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.extension;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class ImagePlugin
extends AbstractFileImporter {
    private static final long serialVersionUID = 5850210255138418118L;
    private static final Log log = LogFactory.getLog(ImagePlugin.class);

    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        path = this.getNearestContainerPath(documentManager, path);
        String docType = this.getDocType();
        if (docType == null) {
            docType = "Picture";
        }
        this.doSecurityCheck(documentManager, path, docType, typeService);
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        content.setFilename(filename);
        DocumentModel docModel = FileManagerUtils.getExistingDocByFileName((CoreSession)documentManager, (String)path, (String)filename);
        if (overwrite && docModel != null) {
            DocumentRef docRef = docModel.getRef();
            if (documentManager.isCheckedOut(docRef)) {
                documentManager.checkIn(docRef, null, null);
            }
            BlobHolder bh = (BlobHolder)docModel.getAdapter(BlobHolder.class);
            bh.setBlob(content.persist());
        } else {
            PathSegmentService pss;
            try {
                pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
            docModel = documentManager.createDocumentModel(docType);
            String title = FileManagerUtils.fetchTitle((String)filename);
            docModel.setPropertyValue("dc:title", (Serializable)((Object)title));
            docModel.setPropertyValue("file:content", (Serializable)content.persist());
            docModel.setPathInfo(path, pss.generatePathSegment(docModel));
            docModel = documentManager.createDocument(docModel);
        }
        documentManager.save();
        log.debug((Object)("Created the Picture: " + docModel.getName() + " with icon : " + docModel.getProperty("common", "icon")));
        return docModel;
    }
}

