/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.service;

import de.odysseus.el.ExpressionFactoryImpl;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.event.CoreEvent;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.platform.audit.api.AuditException;
import org.nuxeo.ecm.platform.audit.api.AuditRuntimeException;
import org.nuxeo.ecm.platform.audit.api.DocumentHistoryReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.FilterMapEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.NXAuditEvents;
import org.nuxeo.ecm.platform.audit.api.document.DocumentHistoryReaderImpl;
import org.nuxeo.ecm.platform.audit.impl.ExtendedInfoImpl;
import org.nuxeo.ecm.platform.audit.impl.LogEntryImpl;
import org.nuxeo.ecm.platform.audit.service.LogEntryProvider;
import org.nuxeo.ecm.platform.audit.service.extension.AdapterDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.EventDescriptor;
import org.nuxeo.ecm.platform.audit.service.extension.ExtendedInfoDescriptor;
import org.nuxeo.ecm.platform.el.ExpressionContext;
import org.nuxeo.ecm.platform.el.ExpressionEvaluator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class NXAuditEventsService
extends DefaultComponent
implements NXAuditEvents {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.audit.service.NXAuditEventsService");
    private static final String EVENT_EXT_POINT = "event";
    private static final String EXTENDED_INFO_EXT_POINT = "extendedInfo";
    private static final String ADAPTER_POINT = "adapter";
    protected static final Log log = LogFactory.getLog(NXAuditEventsService.class);
    protected final Set<ExtendedInfoDescriptor> extendedInfoDescriptors = new HashSet<ExtendedInfoDescriptor>();
    protected final Set<AdapterDescriptor> documentAdapters = new HashSet<AdapterDescriptor>();
    protected final Set<String> eventNames = new HashSet<String>();
    protected final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator((ExpressionFactory)new ExpressionFactoryImpl());
    protected PersistenceProvider persistenceProvider;

    public PersistenceProvider getOrCreatePersistenceProvider() {
        if (this.persistenceProvider == null) {
            this.activatePersistenceProvider();
        }
        return this.persistenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activatePersistenceProvider() {
        Thread thread = Thread.currentThread();
        ClassLoader last = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(PersistenceProvider.class.getClassLoader());
            PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getLocalService(PersistenceProviderFactory.class);
            this.persistenceProvider = persistenceProviderFactory.newProvider("nxaudit-logs");
            this.persistenceProvider.openPersistenceUnit();
        }
        finally {
            thread.setContextClassLoader(last);
        }
    }

    protected void deactivatePersistenceProvider() {
        if (this.persistenceProvider != null) {
            this.persistenceProvider.closePersistenceUnit();
            this.persistenceProvider = null;
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.deactivatePersistenceProvider();
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(EVENT_EXT_POINT)) {
            this.doRegisterEvent((EventDescriptor)contribution);
        } else if (extensionPoint.equals(EXTENDED_INFO_EXT_POINT)) {
            this.doRegisterExtendedInfo((ExtendedInfoDescriptor)contribution);
        } else if (extensionPoint.equals(ADAPTER_POINT)) {
            this.doRegisterAdapter((AdapterDescriptor)contribution);
        }
    }

    protected void doRegisterEvent(EventDescriptor desc) {
        String eventName = desc.getName();
        boolean eventEnabled = desc.getEnabled();
        if (eventEnabled) {
            this.eventNames.add(eventName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registered event: " + eventName));
            }
        } else if (this.eventNames.contains(eventName) && !eventEnabled) {
            this.doUnregisterEvent(desc);
        }
    }

    protected void doRegisterExtendedInfo(ExtendedInfoDescriptor desc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered extended info mapping : " + desc.getKey()));
        }
        this.extendedInfoDescriptors.add(desc);
    }

    protected void doRegisterAdapter(AdapterDescriptor desc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered adapter : " + desc.getName()));
        }
        this.documentAdapters.add(desc);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(EVENT_EXT_POINT)) {
            this.doUnregisterEvent((EventDescriptor)contribution);
        } else if (extensionPoint.equals(EXTENDED_INFO_EXT_POINT)) {
            this.doUnregisterExtendedInfo((ExtendedInfoDescriptor)contribution);
        } else if (extensionPoint.equals(ADAPTER_POINT)) {
            this.doUnregisterAdapter((AdapterDescriptor)contribution);
        }
    }

    protected void doUnregisterEvent(EventDescriptor desc) {
        this.eventNames.remove(desc.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistered event: " + desc.getName()));
        }
    }

    protected void doUnregisterExtendedInfo(ExtendedInfoDescriptor desc) {
        this.extendedInfoDescriptors.remove(desc.getKey());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistered extended info: " + desc.getKey()));
        }
    }

    protected void doUnregisterAdapter(AdapterDescriptor desc) {
        this.documentAdapters.remove(desc.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistered adapter: " + desc.getName()));
        }
    }

    public Set<String> getAuditableEventNames() {
        return this.eventNames;
    }

    public AdapterDescriptor[] getRegisteredAdapters() {
        return this.documentAdapters.toArray(new AdapterDescriptor[this.documentAdapters.size()]);
    }

    protected void doPutExtendedInfos(LogEntry entry, EventContext eventContext, DocumentModel source, Principal principal) {
        if (source instanceof DeletedDocumentModel) {
            return;
        }
        ExpressionContext context = new ExpressionContext();
        if (eventContext != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "message", (Object)eventContext);
        }
        if (source != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "source", (Object)source);
            for (AdapterDescriptor ad : this.documentAdapters) {
                Object adapter = null;
                try {
                    adapter = source.getAdapter(ad.getKlass());
                }
                catch (Exception e) {
                    log.debug((Object)String.format("can't get adapter for %s to log extinfo: %s", source.getPathAsString(), e.getMessage()));
                }
                if (adapter == null) continue;
                this.expressionEvaluator.bindValue((ELContext)context, ad.getName(), adapter);
            }
        }
        if (principal != null) {
            this.expressionEvaluator.bindValue((ELContext)context, "principal", (Object)principal);
        }
        Map extendedInfos = entry.getExtendedInfos();
        for (ExtendedInfoDescriptor descriptor : this.extendedInfoDescriptors) {
            String exp = descriptor.getExpression();
            Serializable value = null;
            try {
                value = (Serializable)this.expressionEvaluator.evaluateExpression((ELContext)context, exp, Serializable.class);
            }
            catch (ELException e) {
                continue;
            }
            if (value == null) continue;
            extendedInfos.put(descriptor.getKey(), this.newExtendedInfo(value));
        }
    }

    protected Principal guardedPrincipal(CoreSession session) {
        try {
            return session.getPrincipal();
        }
        catch (Exception e) {
            throw new AuditRuntimeException("Cannot get principal from " + session, (Throwable)e);
        }
    }

    protected Principal guardedPrincipal(CoreEvent event) {
        try {
            return event.getPrincipal();
        }
        catch (Exception e) {
            throw new AuditRuntimeException("Cannot get principal from " + event, (Throwable)e);
        }
    }

    protected DocumentModel guardedDocument(CoreSession session, DocumentRef reference) {
        if (session == null) {
            return null;
        }
        if (reference == null) {
            return null;
        }
        try {
            return session.getDocument(reference);
        }
        catch (ClientException e) {
            return null;
        }
    }

    protected DocumentModelList guardedDocumentChildren(CoreSession session, DocumentRef reference) throws AuditException {
        try {
            return session.getChildren(reference);
        }
        catch (ClientException e) {
            throw new AuditException("Cannot get children of " + reference, (Throwable)e);
        }
    }

    protected RepositoryManager guardedRepositoryManager() {
        try {
            return (RepositoryManager)Framework.getService(RepositoryManager.class);
        }
        catch (Exception e) {
            throw new AuditRuntimeException("Unable to get RepositoryManager", (Throwable)e);
        }
    }

    protected Repository guardeRepository(String repoId) {
        RepositoryManager manager = this.guardedRepositoryManager();
        Repository repository = manager.getRepository(repoId);
        if (repository == null) {
            throw new AuditRuntimeException("Can not find repository");
        }
        return repository;
    }

    protected CoreSession guardedCoreSession(String repoId) {
        Repository repository = this.guardeRepository(repoId);
        try {
            return repository.open();
        }
        catch (Exception e) {
            throw new AuditRuntimeException("Cannot open core session for " + repoId, (Throwable)e);
        }
    }

    protected LogEntry doCreateAndFillEntryFromDocument(DocumentModel doc, Principal principal) {
        Calendar creationDate;
        LogEntry entry = this.newLogEntry();
        entry.setDocPath(doc.getPathAsString());
        entry.setDocType(doc.getType());
        entry.setDocUUID(doc.getId());
        entry.setRepositoryId(doc.getRepositoryName());
        entry.setPrincipalName("system");
        entry.setCategory("eventDocumentCategory");
        entry.setEventId("documentCreated");
        entry.setDocLifeCycle("project");
        try {
            creationDate = (Calendar)doc.getProperty("dublincore", "created");
        }
        catch (ClientException e) {
            throw new AuditRuntimeException("Cannot fetch date from dublin core for " + doc, (Throwable)e);
        }
        if (creationDate != null) {
            entry.setEventDate(creationDate.getTime());
        }
        this.doPutExtendedInfos(entry, null, doc, principal);
        return entry;
    }

    public void addLogEntries(final List<LogEntry> entries) {
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    NXAuditEventsService.this.addLogEntries(em, entries);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void addLogEntries(EntityManager em, List<LogEntry> entries) {
        LogEntryProvider.createProvider(em).addLogEntries(entries);
    }

    public List<LogEntry> getLogEntriesFor(final String uuid) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

                public List<LogEntry> runWith(EntityManager em) {
                    return NXAuditEventsService.this.getLogEntriesFor(em, uuid);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<LogEntry> getLogEntriesFor(EntityManager em, String uuid) {
        return LogEntryProvider.createProvider(em).getLogEntriesFor(uuid);
    }

    public List<LogEntry> getLogEntriesFor(final String uuid, final Map<String, FilterMapEntry> filterMap, final boolean doDefaultSort) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

                public List<LogEntry> runWith(EntityManager em) {
                    return NXAuditEventsService.this.getLogEntriesFor(em, uuid, filterMap, doDefaultSort);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<LogEntry> getLogEntriesFor(EntityManager em, String uuid, Map<String, FilterMapEntry> filterMap, boolean doDefaultSort) {
        return LogEntryProvider.createProvider(em).getLogEntriesFor(uuid, filterMap, doDefaultSort);
    }

    public LogEntry getLogEntryByID(final long id) {
        try {
            return (LogEntry)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<LogEntry>(){

                public LogEntry runWith(EntityManager em) {
                    return NXAuditEventsService.this.getLogEntryByID(em, id);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public LogEntry getLogEntryByID(EntityManager em, long id) {
        return LogEntryProvider.createProvider(em).getLogEntryByID(id);
    }

    public List<LogEntry> nativeQueryLogs(final String whereClause, final int pageNb, final int pageSize) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

                public List<LogEntry> runWith(EntityManager em) {
                    return NXAuditEventsService.this.nativeQueryLogs(em, whereClause, pageNb, pageSize);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<LogEntry> nativeQueryLogs(EntityManager em, String whereClause, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).nativeQueryLogs(whereClause, pageNb, pageSize);
    }

    public List<?> nativeQuery(final String query, final int pageNb, final int pageSize) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), new PersistenceProvider.RunCallback<List<?>>(){

                public List<?> runWith(EntityManager em) {
                    return NXAuditEventsService.this.nativeQuery(em, query, pageNb, pageSize);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<?> nativeQuery(EntityManager em, String query, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).nativeQuery(query, pageNb, pageSize);
    }

    public List<?> nativeQuery(final String query, final Map<String, Object> params, final int pageNb, final int pageSize) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), new PersistenceProvider.RunCallback<List<?>>(){

                public List<?> runWith(EntityManager em) {
                    return NXAuditEventsService.this.nativeQuery(em, query, params, pageNb, pageSize);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<?> nativeQuery(EntityManager em, String query, Map<String, Object> params, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).nativeQuery(query, params, pageNb, pageSize);
    }

    public List<LogEntry> queryLogs(final String[] eventIds, final String dateRange) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

                public List<LogEntry> runWith(EntityManager em) {
                    return NXAuditEventsService.this.queryLogs(em, eventIds, dateRange);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<LogEntry> queryLogs(EntityManager em, String[] eventIds, String dateRange) {
        return LogEntryProvider.createProvider(em).queryLogs(eventIds, dateRange);
    }

    public List<LogEntry> queryLogsByPage(final String[] eventIds, final String dateRange, final String[] category, final String path, final int pageNb, final int pageSize) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

                public List<LogEntry> runWith(EntityManager em) {
                    return NXAuditEventsService.this.queryLogsByPage(em, eventIds, dateRange, category, path, pageNb, pageSize);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<LogEntry> queryLogsByPage(EntityManager em, String[] eventIds, String dateRange, String[] category, String path, int pageNb, int pageSize) {
        try {
            return LogEntryProvider.createProvider(em).queryLogsByPage(eventIds, dateRange, category, path, pageNb, pageSize);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<LogEntry> queryLogsByPage(final String[] eventIds, final Date limit, final String[] category, final String path, final int pageNb, final int pageSize) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

                public List<LogEntry> runWith(EntityManager em) {
                    return NXAuditEventsService.this.queryLogsByPage(em, eventIds, limit, category, path, pageNb, pageSize);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<LogEntry> queryLogsByPage(EntityManager em, String[] eventIds, Date limit, String[] category, String path, int pageNb, int pageSize) {
        return LogEntryProvider.createProvider(em).queryLogsByPage(eventIds, limit, category, path, pageNb, pageSize);
    }

    public long syncLogCreationEntries(final String repoId, final String path, final Boolean recurs) {
        try {
            return (Long)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Long>(){

                public Long runWith(EntityManager em) {
                    return NXAuditEventsService.this.syncLogCreationEntries(em, repoId, path, recurs);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long syncLogCreationEntries(EntityManager em, String repoId, String path, Boolean recurs) {
        LogEntryProvider provider = LogEntryProvider.createProvider(em);
        provider.removeEntries("documentCreated", path);
        CoreSession session = null;
        try {
            session = this.guardedCoreSession(repoId);
            PathRef rootRef = new PathRef(path);
            DocumentModel root = this.guardedDocument(session, (DocumentRef)rootRef);
            long nbAddedEntries = this.doSyncNode(provider, session, root, recurs);
            if (log.isDebugEnabled()) {
                log.debug((Object)("synced " + nbAddedEntries + " entries on " + path));
            }
            long l = nbAddedEntries;
            return l;
        }
        finally {
            if (session != null) {
                CoreInstance.getInstance().close(session);
            }
        }
    }

    protected long doSyncNode(LogEntryProvider provider, CoreSession session, DocumentModel node, boolean recurs) {
        long nbSyncedEntries = 1L;
        Principal principal = this.guardedPrincipal(session);
        ArrayList<DocumentModel> folderishChildren = new ArrayList<DocumentModel>();
        try {
            provider.addLogEntry(this.doCreateAndFillEntryFromDocument(node, this.guardedPrincipal(session)));
            for (DocumentModel child : this.guardedDocumentChildren(session, node.getRef())) {
                if (child.isFolder() && recurs) {
                    folderishChildren.add(child);
                    continue;
                }
                provider.addLogEntry(this.doCreateAndFillEntryFromDocument(child, principal));
                ++nbSyncedEntries;
            }
        }
        catch (AuditException e) {
            throw new AuditRuntimeException("error occurred while syncing", (Throwable)e);
        }
        if (recurs) {
            for (DocumentModel folderChild : folderishChildren) {
                nbSyncedEntries += this.doSyncNode(provider, session, folderChild, recurs);
            }
        }
        return nbSyncedEntries;
    }

    public void addLogEntry(final LogEntry entry) {
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Integer>(){

                public Integer runWith(EntityManager em) {
                    NXAuditEventsService.this.addLogEntry(em, entry);
                    return 0;
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void addLogEntry(EntityManager em, LogEntry entry) {
        LogEntryProvider.createProvider(em).addLogEntry(entry);
    }

    public Long getEventsCount(final String eventId) {
        try {
            return (Long)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Long>(){

                public Long runWith(EntityManager em) {
                    return NXAuditEventsService.this.getEventsCount(em, eventId);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public Long getEventsCount(EntityManager em, String eventId) {
        return LogEntryProvider.createProvider(em).countEventsById(eventId);
    }

    public List<String> getLoggedEventIds() {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<String>>(){

                public List<String> runWith(EntityManager em) {
                    return NXAuditEventsService.this.getLoggedEventIds(em);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<String> getLoggedEventIds(EntityManager em) {
        return LogEntryProvider.createProvider(em).findEventIds();
    }

    public void logEvent(final Event event) {
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    NXAuditEventsService.this.logEvent(em, event);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void logEvents(final EventBundle eventBundle) {
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    NXAuditEventsService.this.logEvents(em, eventBundle);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void logEvents(EntityManager em, EventBundle eventBundle) {
        boolean processEvents = false;
        for (String name : this.getAuditableEventNames()) {
            if (!eventBundle.containsEventName(name)) continue;
            processEvents = true;
            break;
        }
        if (!processEvents) {
            return;
        }
        for (Event event : eventBundle) {
            this.logEvent(em, event);
        }
    }

    public void logEvent(EntityManager em, Event event) {
        if (!this.getAuditableEventNames().contains(event.getName())) {
            return;
        }
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            this.logDocumentEvent(em, event.getName(), docCtx, new Date(event.getTime()));
        } else {
            this.logMiscEvent(em, event.getName(), ctx, new Date(event.getTime()));
        }
    }

    protected void logDocumentEvent(EntityManager em, String eventName, DocumentEventContext docCtx, Date eventDate) {
        String category;
        DocumentModel document = docCtx.getSourceDocument();
        if (document.hasFacet("SystemDocument")) {
            return;
        }
        Principal principal = docCtx.getPrincipal();
        Map properties = docCtx.getProperties();
        LogEntry entry = this.newLogEntry();
        entry.setEventId(eventName);
        entry.setEventDate(eventDate);
        if (document != null) {
            entry.setDocUUID(document.getId());
            entry.setDocPath(document.getPathAsString());
            entry.setDocType(document.getType());
            entry.setRepositoryId(document.getRepositoryName());
        } else {
            log.warn((Object)("received event " + eventName + " with null document"));
        }
        if (principal != null) {
            String originatingUser = null;
            if (principal instanceof NuxeoPrincipal) {
                originatingUser = ((NuxeoPrincipal)principal).getOriginatingUser();
            }
            entry.setPrincipalName(originatingUser == null ? principal.getName() : originatingUser);
        } else {
            log.warn((Object)("received event " + eventName + " with null principal"));
        }
        entry.setComment((String)properties.get("comment"));
        try {
            if (document.isLifeCycleLoaded()) {
                entry.setDocLifeCycle(document.getCurrentLifeCycleState());
            }
        }
        catch (UnsupportedOperationException uoe) {
            entry.setComment("Document does not exist anymore!");
            log.debug((Object)"Document associated to event does not exists anymore");
        }
        catch (ClientException e1) {
            throw new AuditRuntimeException("Cannot fetch life cycle state from " + document, (Throwable)e1);
        }
        if ("lifecycle_transition_event".equals(eventName)) {
            entry.setDocLifeCycle((String)((Object)docCtx.getProperty("to")));
        }
        if ((category = (String)properties.get("category")) != null) {
            entry.setCategory(category);
        } else {
            entry.setCategory("eventDocumentCategory");
        }
        this.doPutExtendedInfos(entry, (EventContext)docCtx, document, principal);
        this.addLogEntry(em, entry);
    }

    protected void logMiscEvent(EntityManager em, String eventName, EventContext ctx, Date eventDate) {
        Principal principal = ctx.getPrincipal();
        Map properties = ctx.getProperties();
        LogEntry entry = this.newLogEntry();
        entry.setEventId(eventName);
        entry.setEventDate(eventDate);
        if (principal != null) {
            String originatingUser = null;
            if (principal instanceof NuxeoPrincipal) {
                originatingUser = ((NuxeoPrincipal)principal).getOriginatingUser();
            }
            entry.setPrincipalName(originatingUser == null ? principal.getName() : originatingUser);
        }
        entry.setComment((String)properties.get("comment"));
        String category = (String)properties.get("category");
        entry.setCategory(category);
        this.doPutExtendedInfos(entry, ctx, null, principal);
        this.addLogEntry(em, entry);
    }

    public List<LogEntry> queryLogsByPage(EntityManager em, String[] eventIds, String dateRange, String category, String path, int pageNb, int pageSize) {
        String[] categories = new String[]{category};
        return this.queryLogsByPage(em, eventIds, dateRange, categories, path, pageNb, pageSize);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, String dateRange, String category, String path, int pageNb, int pageSize) {
        String[] categories = new String[]{category};
        return this.queryLogsByPage(eventIds, dateRange, categories, path, pageNb, pageSize);
    }

    public List<LogEntry> queryLogsByPage(String[] eventIds, Date limit, String category, String path, int pageNb, int pageSize) {
        String[] categories = new String[]{category};
        return this.queryLogsByPage(eventIds, limit, categories, path, pageNb, pageSize);
    }

    public List<LogEntry> queryLogsByPage(EntityManager em, String[] eventIds, Date limit, String category, String path, int pageNb, int pageSize) {
        String[] categories = new String[]{category};
        return this.queryLogsByPage(em, eventIds, limit, categories, path, pageNb, pageSize);
    }

    public LogEntry newLogEntry() {
        return new LogEntryImpl();
    }

    public ExtendedInfo newExtendedInfo(Serializable value) {
        return ExtendedInfoImpl.createExtendedInfo(value);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.getCanonicalName().equals(DocumentHistoryReader.class.getCanonicalName())) {
            return adapter.cast(new DocumentHistoryReaderImpl());
        }
        return (T)super.getAdapter(adapter);
    }
}

