/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.xmap;

import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.DOMHelper;
import org.nuxeo.common.xmap.Path;
import org.nuxeo.common.xmap.XAccessor;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.XMLBuilder;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAnnotatedMember {
    protected final XAccessor accessor;
    protected Path path;
    protected boolean trim;
    protected Class type;
    protected XAnnotatedObject xao;
    protected XValueFactory valueFactory;
    private final XMap xmap;

    protected XAnnotatedMember(XMap xmap, XAccessor accessor) {
        this.xmap = xmap;
        this.accessor = accessor;
    }

    public XAnnotatedMember(XMap xmap, XAccessor setter, XNode anno) {
        this.xmap = xmap;
        this.accessor = setter;
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.type = setter.getType();
        this.valueFactory = xmap.getValueFactory(this.type);
        if (this.valueFactory == null && this.type.isEnum()) {
            this.valueFactory = new XValueFactory(){

                @Override
                public String serialize(Context arg0, Object arg1) {
                    return ((Enum)arg1).name();
                }

                @Override
                public Object deserialize(Context arg0, String arg1) {
                    return Enum.valueOf(XAnnotatedMember.this.type, arg1);
                }
            };
            xmap.setValueFactory(this.type, this.valueFactory);
        }
        this.xao = xmap.register(this.type);
    }

    protected void setValue(Object instance, Object value) throws Exception {
        try {
            this.accessor.setValue(instance, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("%s, setter=%s, value=%s", e.getMessage(), this.accessor, value), e);
        }
    }

    public void toXML(Object instance, Element parent) throws Exception {
        Element e = XMLBuilder.getOrCreateElement(parent, this.path);
        Object v = this.accessor.getValue(instance);
        if (this.xao == null) {
            String value;
            if (v != null && this.valueFactory != null && (value = this.valueFactory.serialize(null, v)) != null) {
                XMLBuilder.fillField(e, value, this.path.attribute);
            }
        } else {
            XMLBuilder.toXML(v, e, this.xao);
        }
    }

    public void process(Context ctx, Element element) throws Exception {
        Object value = this.getValue(ctx, element);
        if (value != null) {
            this.setValue(ctx.getObject(), value);
        }
    }

    protected Object getValue(Context ctx, Element base) throws Exception {
        if (this.xao != null) {
            Element el = (Element)DOMHelper.getElementNode((Node)base, this.path);
            return el == null ? null : this.xao.newInstance(ctx, el);
        }
        if (this.type == Element.class) {
            return base;
        }
        String val = DOMHelper.getNodeValue(base, this.path);
        if (val != null) {
            if (this.trim) {
                val = val.trim();
            }
            if (this.valueFactory == null) {
                throw new NullPointerException("Missing XValueFactory for " + this.type);
            }
            return this.valueFactory.deserialize(ctx, val);
        }
        return null;
    }
}

