/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class EmbeddedFunctions {
    private static final Pattern wordPattern = Pattern.compile("[\\s\\p{Punct}]+");
    private static final String UNACCENTED = "aaaaaaaceeeeiiii\u00f0nooooo\u00f7ouuuuy\u00fey";
    private static final String STOPWORDS = "a an are and as at be by for from how i in is it of on or that the this to was what when where who will with car donc est il ils je la le les mais ni nous or ou pour tu un une vous www com net org";
    private static final Set<String> stopWords = new HashSet<String>(EmbeddedFunctions.split("a an are and as at be by for from how i in is it of on or that the this to was what when where who will with car donc est il ils je la le les mais ni nous or ou pour tu un une vous www com net org", ' '));

    private static boolean isLogEnabled() {
        return false;
    }

    private static void logDebug(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInTree(Serializable id, Serializable baseId) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        try {
            boolean bl = EmbeddedFunctions.isInTree(conn, id, baseId);
            return bl;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInTree(Connection conn, Serializable id, Serializable baseId) throws SQLException {
        if (baseId == null || id == null || baseId.equals(id)) {
            return false;
        }
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("SELECT PARENTID FROM HIERARCHY WHERE ID = ?");
            do {
                ps.setObject(1, id);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    boolean bl = false;
                    return bl;
                }
                id = id instanceof String ? rs.getString(1) : Long.valueOf(rs.getLong(1));
                if (rs.wasNull()) {
                    id = null;
                }
                rs.close();
                if (!baseId.equals(id)) continue;
                boolean bl = true;
                return bl;
            } while (id != null);
            boolean bl = false;
            return bl;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAccessAllowed(Serializable id, Set<String> principals, Set<String> permissions) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        try {
            boolean bl = EmbeddedFunctions.isAccessAllowed(conn, id, principals, permissions);
            return bl;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAccessAllowed(Connection conn, Serializable id, Set<String> principals, Set<String> permissions) throws SQLException {
        if (EmbeddedFunctions.isLogEnabled()) {
            EmbeddedFunctions.logDebug("isAccessAllowed " + id + " " + principals + " " + permissions);
        }
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        Statement ps3 = null;
        try {
            Serializable newId;
            ps1 = conn.prepareStatement("SELECT \"GRANT\", \"PERMISSION\", \"USER\" FROM \"ACLS\" WHERE ID = ? ORDER BY POS");
            ps2 = conn.prepareStatement("SELECT PARENTID FROM HIERARCHY WHERE ID = ?");
            boolean first = true;
            do {
                ps1.setObject(1, id);
                ResultSet rs = ps1.executeQuery();
                while (rs.next()) {
                    boolean grant = rs.getShort(1) != 0;
                    String permission = rs.getString(2);
                    String user = rs.getString(3);
                    if (EmbeddedFunctions.isLogEnabled()) {
                        EmbeddedFunctions.logDebug(" -> " + user + " " + permission + " " + grant);
                    }
                    if (!principals.contains(user) || !permissions.contains(permission)) continue;
                    if (EmbeddedFunctions.isLogEnabled()) {
                        EmbeddedFunctions.logDebug(" => " + grant);
                    }
                    boolean bl = grant;
                    return bl;
                }
                ps2.setObject(1, id);
                rs = ps2.executeQuery();
                if (rs.next()) {
                    newId = (Serializable)rs.getObject(1);
                    if (rs.wasNull()) {
                        newId = null;
                    }
                } else {
                    newId = null;
                }
                if (first && newId == null) {
                    ps3 = conn.prepareStatement("SELECT VERSIONABLEID FROM VERSIONS WHERE ID = ?");
                    ps3.setObject(1, id);
                    rs = ps3.executeQuery();
                    if (rs.next()) {
                        newId = (Serializable)rs.getObject(1);
                        if (rs.wasNull()) {
                            newId = null;
                        }
                    } else {
                        newId = null;
                    }
                }
                first = false;
            } while ((id = newId) != null);
            if (EmbeddedFunctions.isLogEnabled()) {
                EmbeddedFunctions.logDebug(" => false (root)");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (ps1 != null) {
                ps1.close();
            }
            if (ps2 != null) {
                ps2.close();
            }
            if (ps3 != null) {
                ps3.close();
            }
        }
    }

    public static String parseFullText(String string1, String string2) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(EmbeddedFunctions.parseFullText(string1));
        set.addAll(EmbeddedFunctions.parseFullText(string2));
        ArrayList<String> words = new ArrayList<String>(set);
        Collections.sort(words);
        return EmbeddedFunctions.join(words, ' ');
    }

    protected static Set<String> parseFullText(String string) {
        if (string == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String word : wordPattern.split(string)) {
            String w = EmbeddedFunctions.parseWord(word);
            if (w == null) continue;
            set.add(w);
        }
        return set;
    }

    protected static boolean matchesFullText(String fulltext, String query) {
        if (fulltext == null || query == null) {
            return false;
        }
        Set<String> words = EmbeddedFunctions.split(query, ' ');
        if (words.isEmpty()) {
            return false;
        }
        Set<String> fulltextWords = EmbeddedFunctions.split(fulltext, ' ');
        for (String word : words) {
            if (fulltextWords.contains(word)) continue;
            return false;
        }
        return true;
    }

    public static final String parseWord(String string) {
        String word;
        int len = string.length();
        if (len < 3) {
            return null;
        }
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            if (c == '\u00e6') {
                buf.append("ae");
                continue;
            }
            if (c >= '\u00e0' && c <= '\u00ff') {
                buf.append(UNACCENTED.charAt(c - 224));
                continue;
            }
            if (c == '\u0153') {
                buf.append("oe");
                continue;
            }
            buf.append(c);
        }
        int l = buf.length();
        if (l > 3 && buf.charAt(l - 1) == 's') {
            buf.setLength(l - 1);
        }
        if (stopWords.contains(word = buf.toString())) {
            return null;
        }
        return word;
    }

    public static Set<String> split(String string) {
        return EmbeddedFunctions.split(string, '|');
    }

    public static Set<String> split(String string, char sep) {
        int len = string.length();
        if (len == 0) {
            return Collections.emptySet();
        }
        int end = string.indexOf(sep);
        if (end == -1) {
            return Collections.singleton(string);
        }
        HashSet<String> set = new HashSet<String>();
        int start = 0;
        do {
            String segment = string.substring(start, end);
            set.add(segment);
        } while ((end = string.indexOf(sep, start = end + 1)) != -1);
        if (start < len) {
            set.add(string.substring(start));
        } else {
            set.add("");
        }
        return set;
    }

    private static final String join(Collection<String> strings, char sep) {
        if (strings == null || strings.isEmpty()) {
            return "";
        }
        int size = 0;
        for (String word : strings) {
            size += word.length() + 1;
        }
        StringBuilder buf = new StringBuilder(size);
        for (String word : strings) {
            buf.append(word);
            buf.append(sep);
        }
        buf.setLength(size - 1);
        return buf.toString();
    }
}

