/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.registries;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class DocumentTypeRegistry
extends ContributionFragmentRegistry<DocumentType> {
    protected final Map<String, DocumentType> types = new HashMap<String, DocumentType>();
    protected final Map<String, Set<String>> inheritanceCache = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> facetsCache;

    public String getContributionId(DocumentType contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, DocumentType contrib, DocumentType newOrigContrib) {
        this.types.put(id, contrib);
        this.facetsCache = null;
    }

    public void contributionRemoved(String id, DocumentType docType) {
        this.types.remove(id);
        if (docType != null) {
            this.removeFromFacetsCache(docType);
            this.removeFromInheritanceCache(docType);
        }
    }

    private void removeFromFacetsCache(DocumentType docType) {
        if (this.facetsCache == null) {
            return;
        }
        String name = docType.getName();
        for (String facet : docType.getFacets()) {
            Set<String> types = this.facetsCache.get(facet);
            types.remove(name);
            if (!types.isEmpty()) continue;
            this.facetsCache.remove(facet);
        }
    }

    private void removeFromInheritanceCache(DocumentType docType) {
        String name = docType.getName();
        for (String type : this.inheritanceCache.keySet()) {
            Set<String> types = this.inheritanceCache.get(type);
            types.remove(name);
        }
        this.inheritanceCache.remove(name);
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public DocumentType clone(DocumentType orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(DocumentType src, DocumentType dst) {
        throw new UnsupportedOperationException();
    }

    public DocumentType getType(String name) {
        return this.types.get(name);
    }

    public DocumentType[] getDocumentTypes() {
        return this.types.values().toArray(new DocumentType[this.types.size()]);
    }

    public int size() {
        return this.types.size();
    }

    public Set<String> getDocumentTypeNamesForFacet(String facet) {
        if (this.facetsCache == null) {
            this.initFacetsCache();
        }
        return this.facetsCache.get(facet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFacetsCache() {
        if (this.facetsCache != null) {
            return;
        }
        DocumentTypeRegistry documentTypeRegistry = this;
        synchronized (documentTypeRegistry) {
            this.facetsCache = new HashMap<String, Set<String>>();
            for (DocumentType dt : this.getDocumentTypes()) {
                for (String facet : dt.getFacets()) {
                    Set<String> dts = this.facetsCache.get(facet);
                    if (dts == null) {
                        dts = new HashSet<String>();
                        this.facetsCache.put(facet, dts);
                    }
                    dts.add(dt.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDocumentTypeNamesExtending(String docTypeName) {
        Set<String> res = this.inheritanceCache.get(docTypeName);
        if (res != null) {
            return res;
        }
        Map<String, Set<String>> map = this.inheritanceCache;
        synchronized (map) {
            res = this.inheritanceCache.get(docTypeName);
            if (res != null) {
                return res;
            }
            if (this.getType(docTypeName) == null) {
                return null;
            }
            res = new HashSet<String>();
            res.add(docTypeName);
            for (DocumentType dt : this.getDocumentTypes()) {
                Type parent = dt.getSuperType();
                if (parent == null || !docTypeName.equals(parent.getName())) continue;
                res.addAll(this.getDocumentTypeNamesExtending(dt.getName()));
            }
            this.inheritanceCache.put(docTypeName, res);
            return res;
        }
    }

    public void clear() {
        this.types.clear();
        if (this.facetsCache != null) {
            this.facetsCache.clear();
        }
        this.contribs.clear();
    }
}

