/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme;

import java.io.StringWriter;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;

public class CssStringWriter
extends StringWriter {
    public String toText() {
        String text = this.toString();
        this.getBuffer().setLength(0);
        return text;
    }

    void write(LexicalUnit lu, String separator) {
        String prefix = "";
        for (LexicalUnit current = lu; current != null; current = current.getNextLexicalUnit()) {
            this.write(prefix);
            this.write(current);
            prefix = separator;
        }
    }

    private void writeHex(LexicalUnit lu) {
        this.write("#");
        for (LexicalUnit current = lu; current != null; current = current.getNextLexicalUnit()) {
            if (current.getLexicalUnitType() != 13) continue;
            String value = Integer.toHexString(current.getIntegerValue());
            if (value.length() == 1) {
                value = String.format("0%s", value);
            }
            this.write(value);
        }
    }

    void write(LexicalUnit lu) {
        short type = lu.getLexicalUnitType();
        switch (type) {
            case 24: {
                this.write("url(");
                this.write(lu.getStringValue());
                this.write(")");
                break;
            }
            case 36: {
                this.write('\"');
                this.write(lu.getStringValue());
                this.write('\"');
                break;
            }
            case 35: {
                this.write(lu.getStringValue());
                break;
            }
            case 14: {
                this.write(lu.getFloatValue());
                break;
            }
            case 17: {
                this.write(lu.getFloatValue());
                this.write("px");
                break;
            }
            case 20: {
                this.write(lu.getFloatValue());
                this.write("mm");
                break;
            }
            case 19: {
                this.write(lu.getFloatValue());
                this.write("cm");
                break;
            }
            case 23: {
                this.write(lu.getFloatValue());
                this.write("%");
                break;
            }
            case 21: {
                this.write(lu.getFloatValue());
                this.write("pt");
                break;
            }
            case 15: {
                this.write(lu.getFloatValue());
                this.write("em");
                break;
            }
            case 13: {
                this.write(lu.getIntegerValue());
                break;
            }
            case 41: {
                this.write(lu.getFunctionName());
                this.write("(");
                this.write(lu.getParameters(), "");
                this.write(")");
                break;
            }
            case 27: {
                this.writeHex(lu.getParameters());
                break;
            }
            case 0: {
                this.write(",");
                break;
            }
            case 12: {
                this.write("inherit");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Lexical unit type " + type + " is not handled");
            }
        }
    }

    private void write(Condition condition) {
        switch (condition.getConditionType()) {
            case 10: {
                AttributeCondition pseudoClassCond = (AttributeCondition)condition;
                this.write(":");
                this.write(pseudoClassCond.getValue());
                break;
            }
            case 9: {
                AttributeCondition classCond = (AttributeCondition)condition;
                this.write(".");
                this.write(classCond.getValue());
                break;
            }
            case 4: {
                AttributeCondition attributeCond = (AttributeCondition)condition;
                this.write("[");
                this.write(attributeCond.getLocalName());
                this.write("=");
                this.write(attributeCond.getValue());
                this.write("]");
                break;
            }
            case 0: {
                CombinatorCondition andCond = (CombinatorCondition)condition;
                Condition first = andCond.getFirstCondition();
                Condition second = andCond.getSecondCondition();
                this.write(first);
                this.write(second);
                break;
            }
            case 5: {
                AttributeCondition idCond = (AttributeCondition)condition;
                this.write("#");
                this.write(idCond.getValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("condition type = " + condition.getConditionType() + " with class " + condition.getClass().getName());
            }
        }
    }

    public void write(Selector sel) {
        switch (sel.getSelectorType()) {
            case 0: {
                ConditionalSelector conditionalSel = (ConditionalSelector)sel;
                Condition condition = conditionalSel.getCondition();
                SimpleSelector simpleSel = conditionalSel.getSimpleSelector();
                this.write((Selector)simpleSel);
                this.write(condition);
                break;
            }
            case 11: {
                DescendantSelector childSel = (DescendantSelector)sel;
                Selector ancestorSel = childSel.getAncestorSelector();
                SimpleSelector simpleSel = childSel.getSimpleSelector();
                if (simpleSel.getSelectorType() == 9) {
                    ElementSelector elementSel = (ElementSelector)simpleSel;
                    this.write(ancestorSel);
                    this.write(":");
                    this.write(elementSel.getLocalName());
                    break;
                }
                this.write(ancestorSel);
                this.write(">");
                this.write((Selector)simpleSel);
                break;
            }
            case 10: {
                DescendantSelector descendantSel = (DescendantSelector)sel;
                SimpleSelector simpleSel = descendantSel.getSimpleSelector();
                this.write(descendantSel.getAncestorSelector());
                if (simpleSel.getSelectorType() == 9) {
                    ElementSelector pseudoElementSel = (ElementSelector)simpleSel;
                    this.write(":");
                    this.write(pseudoElementSel.getLocalName());
                    break;
                }
                this.write(" ");
                this.write((Selector)simpleSel);
                break;
            }
            case 4: {
                ElementSelector elementSel = (ElementSelector)sel;
                if (elementSel.getLocalName() == null) break;
                this.write(elementSel.getLocalName());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Selector type = " + sel.getSelectorType() + " with class " + sel.getClass().getName());
            }
        }
    }

    private void write(float f) {
        if (Math.floor(f) == (double)f) {
            this.write((int)f);
        } else {
            this.write(Float.toString(f));
        }
    }

    private void write(char c) {
        this.write(Character.toString(c));
    }

    @Override
    public void write(int i) {
        this.write(Integer.toString(i));
    }
}

