/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public abstract class FileView extends Composite {

    protected Uploader uploader;

    protected FileRef file;

    public FileView(Uploader uploader, FileRef file) {
        this.uploader = uploader;
        this.file = file;
        Widget widget = createWidget();
        widget.addStyleName("upload-file-view");
        initWidget(widget);
    }

    public Uploader getUploader() {
        return uploader;
    }

    public FileRef getFile() {
        return file;
    }

    public void remove() {
        uploader.removeFile(file);
    }

    protected abstract Widget createWidget();

    protected void onUploading() {
        // do nothing
    }

    protected void onRemoved() {
        // do nothing
    }

    protected void onStored() {
        // do nothing
    }

    protected void onUploadDone() {
        // do nothing
    }

    protected void onUploadError() {
        // do nothing
    }

}
