/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url.codec;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class DocumentIdCodec
extends AbstractDocumentViewCodec {
    public static final String PREFIX = "nxdoc";
    public static final String URLPattern = "/(\\w+)/([a-zA-Z_0-9\\-]+)(/([a-zA-Z_0-9\\-\\.]*))?(/)?(\\?(.*)?)?";

    public DocumentIdCodec() {
    }

    public DocumentIdCodec(String prefix) {
    }

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (docLoc != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(docLoc.getServerName());
            IdRef docRef = docLoc.getIdRef();
            if (docRef == null) {
                return null;
            }
            items.add(docRef.toString());
            String viewId = docView.getViewId();
            if (viewId != null) {
                items.add(viewId);
            }
            String uri = StringUtils.join(items, (String)"/");
            return URIUtils.addParametersToURIQuery((String)uri, (Map)docView.getParameters());
        }
        return null;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + URLPattern);
        Matcher m = pattern.matcher(url);
        if (m.matches() && m.groupCount() >= 4) {
            String server = m.group(1);
            String uuid = m.group(2);
            IdRef docRef = new IdRef(uuid);
            String viewId = m.group(4);
            Map params = null;
            if (m.groupCount() > 6) {
                String query = m.group(7);
                params = URIUtils.getRequestParameters((String)query);
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, (DocumentRef)docRef);
            return new DocumentViewImpl((DocumentLocation)docLoc, viewId, params);
        }
        return null;
    }
}

