/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.OpenXmlContentHandler;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.XmlZip2TextConverter;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.presentation.PresentationSlide;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PPTX2TextConverter
extends XmlZip2TextConverter {
    protected static final Log log = LogFactory.getLog(PPTX2TextConverter.class);
    private static final String PRESENTATION_SLIDE_ZIP_ENTRY_NAME_PREFIX = "ppt/slides/slide";

    @Override
    protected void readXmlZipContent(ZipInputStream zis, XMLReader reader, StringBuilder sb) throws IOException, SAXException {
        TreeSet<PresentationSlide> slides = new TreeSet<PresentationSlide>();
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            String zipEntryName = zipEntry.getName();
            if (zipEntryName.startsWith(PRESENTATION_SLIDE_ZIP_ENTRY_NAME_PREFIX) && zipEntryName.length() > PRESENTATION_SLIDE_ZIP_ENTRY_NAME_PREFIX.length()) {
                char slideNumberChar = zipEntryName.charAt(PRESENTATION_SLIDE_ZIP_ENTRY_NAME_PREFIX.length());
                int slideNumber = -1;
                try {
                    slideNumber = Integer.parseInt(String.valueOf(slideNumberChar));
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)"Slide number is not an non integer, won't take this slide into account.");
                }
                if (slideNumber > -1) {
                    OpenXmlContentHandler contentHandler = new OpenXmlContentHandler();
                    reader.setContentHandler(contentHandler);
                    reader.parse(new InputSource(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)zis))));
                    slides.add(new PresentationSlide(contentHandler.getContent(), slideNumber));
                }
            }
            zipEntry = zis.getNextEntry();
        }
        if (!slides.isEmpty()) {
            for (PresentationSlide slide : slides) {
                sb.append(slide.getContent());
                sb.append("\n");
            }
        }
    }
}

