/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.cookies;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisHttpCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmisCookieStoreImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<URI, ArrayList<CmisHttpCookie>> storeMap;

    public CmisCookieStoreImpl() {
        this(1000);
    }

    public CmisCookieStoreImpl(final int maxUrls) {
        this.storeMap = new LinkedHashMap<URI, ArrayList<CmisHttpCookie>>(maxUrls + 1, 0.7f, true){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean removeEldestEntry(Map.Entry<URI, ArrayList<CmisHttpCookie>> eldest) {
                return this.size() > maxUrls;
            }
        };
    }

    public void add(URI uri, CmisHttpCookie cookie) {
        if (uri == null || cookie == null) {
            throw new NullPointerException();
        }
        ArrayList<Object> cookies = null;
        if (this.storeMap.containsKey(uri)) {
            cookies = this.storeMap.get(uri);
            cookies.remove(cookie);
            cookies.add(cookie);
            if (cookies.size() > 1) {
                this.cleanCookieList(cookies);
            }
        } else {
            cookies = new ArrayList<CmisHttpCookie>();
            cookies.add(cookie);
            this.storeMap.put(uri, cookies);
        }
    }

    public List<CmisHttpCookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("URI is null!");
        }
        ArrayList<CmisHttpCookie> cookies = this.storeMap.get(uri);
        if (cookies == null) {
            cookies = new ArrayList<CmisHttpCookie>();
        } else {
            this.cleanCookieList((List<CmisHttpCookie>)cookies);
        }
        ArrayList<URI> uris = new ArrayList<URI>(this.storeMap.keySet());
        for (URI u : uris) {
            if (u.equals(uri)) continue;
            List listCookie = this.storeMap.get(u);
            for (CmisHttpCookie cookie : listCookie) {
                if (!CmisHttpCookie.domainMatches(cookie.getDomain(), uri.getHost())) continue;
                if (cookie.hasExpired()) {
                    listCookie.remove(cookie);
                    if (!listCookie.isEmpty()) continue;
                    this.storeMap.remove(u);
                    continue;
                }
                if (cookie.hasExpired() || cookies.contains(cookie)) continue;
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    private void cleanCookieList(List<CmisHttpCookie> cookies) {
        for (CmisHttpCookie cookie : cookies) {
            if (!cookie.hasExpired()) continue;
            cookies.remove(cookie);
        }
    }

    public List<CmisHttpCookie> getCookies() {
        ArrayList<CmisHttpCookie> cookies = new ArrayList<CmisHttpCookie>();
        Collection<ArrayList<CmisHttpCookie>> values = this.storeMap.values();
        for (ArrayList<CmisHttpCookie> list : values) {
            for (CmisHttpCookie cookie : list) {
                if (cookie.hasExpired()) {
                    list.remove(cookie);
                    continue;
                }
                if (cookies.contains(cookie)) continue;
                cookies.add(cookie);
            }
        }
        return Collections.unmodifiableList(cookies);
    }

    public List<URI> getURIs() {
        return new ArrayList<URI>(this.storeMap.keySet());
    }

    public boolean remove(URI uri, CmisHttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("Cookie is null!");
        }
        boolean success = false;
        Collection<ArrayList<CmisHttpCookie>> values = this.storeMap.values();
        for (ArrayList<CmisHttpCookie> list : values) {
            if (!list.remove(cookie)) continue;
            success = true;
        }
        return success;
    }

    public boolean removeAll() {
        if (!this.storeMap.isEmpty()) {
            this.storeMap.clear();
        }
        return true;
    }
}

