/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.platform.audit.api.AuditException;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.runtime.api.Framework;

public class AuditEventLogger
implements PostCommitFilteringEventListener {
    private static final Log log = LogFactory.getLog(AuditEventLogger.class);

    public boolean acceptEvent(Event event) {
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        if (logger == null) {
            return false;
        }
        return logger.getAuditableEventNames().contains(event.getName());
    }

    public void handleEvent(EventBundle events) throws ClientException {
        if (!(events instanceof ReconnectedEventBundle)) {
            throw new AssertionError((Object)("Not a reconnected event bundle : " + events.getClass().getName()));
        }
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        if (logger != null) {
            try {
                logger.logEvents(events);
            }
            catch (AuditException e) {
                log.error((Object)"Unable to persist event bundle into audit log", (Throwable)e);
            }
        } else {
            log.error((Object)"Can not reach AuditLogger");
        }
    }
}

