/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.handler;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributes;
import com.sun.facelets.tag.jsf.ComponentConfig;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.international.TimeZoneSelector;
import org.nuxeo.ecm.platform.ui.web.tag.handler.GenericHtmlComponentHandler;
import org.richfaces.component.html.HtmlCalendar;

public class InputDateTimeTagHandler
extends GenericHtmlComponentHandler {
    private static final Log log = LogFactory.getLog(InputDateTimeTagHandler.class);
    protected final String defaultTime;

    public InputDateTimeTagHandler(ComponentConfig config) {
        super(config);
        TagAttributes attributes = config.getTag().getAttributes();
        this.defaultTime = this.getValue(attributes, "defaultTime", "12:00");
    }

    protected String getValue(TagAttributes attrs, String name, String defaultValue) {
        TagAttribute attr = attrs.get(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.alias("format", "datePattern");
        m.ignore("showsTime");
        m.alias("styleClass", "inputStyle");
        m.alias("triggerLabel", "buttonLabel");
        m.alias("triggerImg", "buttonIcon");
        m.alias("triggerStyleClass", "buttonClass");
        m.add((Metadata)new TagMetaData());
        return m;
    }

    protected void setAttributes(FaceletContext ctx, Object instance) {
        super.setAttributes(ctx, instance);
        this.setDefaultTime((HtmlCalendar)instance);
    }

    protected void setDefaultTime(HtmlCalendar instance) {
        Date date;
        HtmlCalendar c = instance;
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        format.setTimeZone(TimeZoneSelector.instance().getTimeZone());
        try {
            date = format.parse(this.defaultTime);
        }
        catch (ParseException e) {
            return;
        }
        c.setDefaultTime((Object)date);
    }

    class TagMetaData
    extends Metadata {
        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (!(instance instanceof HtmlCalendar)) {
                log.error((Object)("Cannot apply date time component metadata, not a HtmlCalendar instance: " + instance));
                return;
            }
            HtmlCalendar c = (HtmlCalendar)instance;
            c.setPopup(true);
            c.setEnableManualInput(true);
            c.setShowApplyButton(false);
            c.setZindex(1500);
            c.setTimeZone(TimeZoneSelector.instance().getTimeZone());
            c.setLocale((Object)LocaleSelector.instance().getLocale());
        }
    }
}

