/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task;

import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.core.query.sql.NXQL;

public class TaskQueryConstant {
    public static final String TASK_VARIABLES_WHERE_CLAUSE = "nt:task_variables/*/key = '%s' AND nt:task_variables/*/value = '%s'";
    public static final String TASK_ACTORS_WHERE_CLAUSE = " nt:actors IN (%s) ";
    public static final String GET_TASKS_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0";
    public static final String GET_TASKS_FOR_ACTORS_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:actors IN (%s) ";
    public static final String GET_TASKS_FOR_TARGET_DOCUMENT_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:targetDocumentId = '%s'";
    public static final String GET_TASKS_FOR_TARGET_DOCUMENT_AND_ACTORS_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:targetDocumentId = '%s' AND nt:actors IN (%s) ";
    public static final String GET_TASKS_FOR_PROCESS_ID_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:processId = '%s' ";
    public static final String GET_TASKS_FOR_PROCESS_ID_AND_ACTORS_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:processId = '%s' AND nt:actors IN (%s) ";
    public static final String GET_TASKS_FOR_PROCESS_ID_AND_NODE_ID_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND ecm:currentLifeCycleState NOT IN ('ended', 'cancelled') AND ecm:isProxy = 0 AND nt:processId = '%s'  AND nt:task_variables/*/key = 'nodeId' AND nt:task_variables/*/value =  '%s' ";

    public static String getVariableWhereClause(String key, String value) {
        return String.format(TASK_VARIABLES_WHERE_CLAUSE, key, value);
    }

    public static String getActorsWhereClause(List<String> actors) {
        return String.format(TASK_ACTORS_WHERE_CLAUSE, TaskQueryConstant.formatStringList(actors));
    }

    public static String formatStringList(List<String> actors) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> actorIterator = actors.iterator();
        while (actorIterator.hasNext()) {
            String userName = actorIterator.next();
            sb.append(NXQL.escapeString((String)userName));
            if (!actorIterator.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }
}

