/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;

public class HSSFCellStyle
implements CellStyle {
    private ExtendedFormatRecord format = null;
    private short index = 0;
    private Workbook workbook = null;

    protected HSSFCellStyle(short index, ExtendedFormatRecord rec, HSSFWorkbook workbook) {
        this(index, rec, workbook.getWorkbook());
    }

    protected HSSFCellStyle(short index, ExtendedFormatRecord rec, Workbook workbook) {
        this.workbook = workbook;
        this.index = index;
        this.format = rec;
    }

    public short getIndex() {
        return this.index;
    }

    public HSSFCellStyle getParentStyle() {
        if (this.format.getParentIndex() == 0) {
            return null;
        }
        return new HSSFCellStyle(this.format.getParentIndex(), this.workbook.getExFormatAt(this.format.getParentIndex()), this.workbook);
    }

    public void setDataFormat(short fmt) {
        this.format.setFormatIndex(fmt);
    }

    public short getDataFormat() {
        return this.format.getFormatIndex();
    }

    public String getDataFormatString() {
        return this.getDataFormatString(this.workbook);
    }

    public String getDataFormatString(org.apache.poi.ss.usermodel.Workbook workbook) {
        HSSFDataFormat format = new HSSFDataFormat(((HSSFWorkbook)workbook).getWorkbook());
        short idx = this.getDataFormat();
        return idx == -1 ? "General" : format.getFormat(this.getDataFormat());
    }

    public String getDataFormatString(Workbook workbook) {
        HSSFDataFormat format = new HSSFDataFormat(workbook);
        return format.getFormat(this.getDataFormat());
    }

    public void setFont(Font font) {
        this.setFont((HSSFFont)font);
    }

    public void setFont(HSSFFont font) {
        this.format.setIndentNotParentFont(true);
        short fontindex = font.getIndex();
        this.format.setFontIndex(fontindex);
    }

    public short getFontIndex() {
        return this.format.getFontIndex();
    }

    public HSSFFont getFont(org.apache.poi.ss.usermodel.Workbook parentWorkbook) {
        return ((HSSFWorkbook)parentWorkbook).getFontAt(this.getFontIndex());
    }

    public void setHidden(boolean hidden) {
        this.format.setIndentNotParentCellOptions(true);
        this.format.setHidden(hidden);
    }

    public boolean getHidden() {
        return this.format.isHidden();
    }

    public void setLocked(boolean locked) {
        this.format.setIndentNotParentCellOptions(true);
        this.format.setLocked(locked);
    }

    public boolean getLocked() {
        return this.format.isLocked();
    }

    public void setAlignment(short align) {
        this.format.setIndentNotParentAlignment(true);
        this.format.setAlignment(align);
    }

    public short getAlignment() {
        return this.format.getAlignment();
    }

    public void setWrapText(boolean wrapped) {
        this.format.setIndentNotParentAlignment(true);
        this.format.setWrapText(wrapped);
    }

    public boolean getWrapText() {
        return this.format.getWrapText();
    }

    public void setVerticalAlignment(short align) {
        this.format.setVerticalAlignment(align);
    }

    public short getVerticalAlignment() {
        return this.format.getVerticalAlignment();
    }

    public void setRotation(short rotation) {
        if (rotation < 0 && rotation >= -90) {
            rotation = (short)(90 - rotation);
        } else if (rotation < -90 || rotation > 90) {
            throw new IllegalArgumentException("The rotation must be between -90 and 90 degrees");
        }
        this.format.setRotation(rotation);
    }

    public short getRotation() {
        short rotation = this.format.getRotation();
        if (rotation > 90) {
            rotation = (short)(90 - rotation);
        }
        return rotation;
    }

    public void setIndention(short indent) {
        this.format.setIndent(indent);
    }

    public short getIndention() {
        return this.format.getIndent();
    }

    public void setBorderLeft(short border) {
        this.format.setIndentNotParentBorder(true);
        this.format.setBorderLeft(border);
    }

    public short getBorderLeft() {
        return this.format.getBorderLeft();
    }

    public void setBorderRight(short border) {
        this.format.setIndentNotParentBorder(true);
        this.format.setBorderRight(border);
    }

    public short getBorderRight() {
        return this.format.getBorderRight();
    }

    public void setBorderTop(short border) {
        this.format.setIndentNotParentBorder(true);
        this.format.setBorderTop(border);
    }

    public short getBorderTop() {
        return this.format.getBorderTop();
    }

    public void setBorderBottom(short border) {
        this.format.setIndentNotParentBorder(true);
        this.format.setBorderBottom(border);
    }

    public short getBorderBottom() {
        return this.format.getBorderBottom();
    }

    public void setLeftBorderColor(short color) {
        this.format.setLeftBorderPaletteIdx(color);
    }

    public short getLeftBorderColor() {
        return this.format.getLeftBorderPaletteIdx();
    }

    public void setRightBorderColor(short color) {
        this.format.setRightBorderPaletteIdx(color);
    }

    public short getRightBorderColor() {
        return this.format.getRightBorderPaletteIdx();
    }

    public void setTopBorderColor(short color) {
        this.format.setTopBorderPaletteIdx(color);
    }

    public short getTopBorderColor() {
        return this.format.getTopBorderPaletteIdx();
    }

    public void setBottomBorderColor(short color) {
        this.format.setBottomBorderPaletteIdx(color);
    }

    public short getBottomBorderColor() {
        return this.format.getBottomBorderPaletteIdx();
    }

    public void setFillPattern(short fp) {
        this.format.setAdtlFillPattern(fp);
    }

    public short getFillPattern() {
        return this.format.getAdtlFillPattern();
    }

    private void checkDefaultBackgroundFills() {
        if (this.format.getFillForeground() == 64) {
            if (this.format.getFillBackground() != 65) {
                this.setFillBackgroundColor((short)65);
            }
        } else if (this.format.getFillBackground() == 65 && this.format.getFillForeground() != 64) {
            this.setFillBackgroundColor((short)64);
        }
    }

    public void setFillBackgroundColor(short bg) {
        this.format.setFillBackground(bg);
        this.checkDefaultBackgroundFills();
    }

    public short getFillBackgroundColor() {
        short result = this.format.getFillBackground();
        if (result == 65) {
            return 64;
        }
        return result;
    }

    public void setFillForegroundColor(short bg) {
        this.format.setFillForeground(bg);
        this.checkDefaultBackgroundFills();
    }

    public short getFillForegroundColor() {
        return this.format.getFillForeground();
    }

    public String getUserStyleName() {
        StyleRecord sr = this.workbook.getStyleRecord(this.index);
        if (sr == null) {
            return null;
        }
        if (sr.isBuiltin()) {
            return null;
        }
        return sr.getName();
    }

    public void setUserStyleName(String styleName) {
        StyleRecord sr = this.workbook.getStyleRecord(this.index);
        if (sr == null) {
            sr = this.workbook.createStyleRecord(this.index);
        }
        if (sr.isBuiltin()) {
            throw new IllegalArgumentException("Unable to set user specified style names for built in styles!");
        }
        sr.setName(styleName);
    }

    public void verifyBelongsToWorkbook(HSSFWorkbook wb) {
        if (wb.getWorkbook() != this.workbook) {
            throw new IllegalArgumentException("This Style does not belong to the supplied Workbook. Are you trying to assign a style from one workbook to the cell of a differnt workbook?");
        }
    }

    public void cloneStyleFrom(CellStyle source) {
        if (!(source instanceof HSSFCellStyle)) {
            throw new IllegalArgumentException("Can only clone from one HSSFCellStyle to another, not between HSSFCellStyle and XSSFCellStyle");
        }
        this.cloneStyleFrom((HSSFCellStyle)source);
    }

    public void cloneStyleFrom(HSSFCellStyle source) {
        this.format.cloneStyleFrom(source.format);
        if (this.workbook != source.workbook) {
            short fmt = (short)this.workbook.createFormat(source.getDataFormatString());
            this.setDataFormat(fmt);
            FontRecord fr = this.workbook.createNewFont();
            fr.cloneStyleFrom(source.workbook.getFontRecordAt(source.getFontIndex()));
            HSSFFont font = new HSSFFont((short)this.workbook.getFontIndex(fr), fr);
            this.setFont(font);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HSSFCellStyle) {
            HSSFCellStyle other = (HSSFCellStyle)obj;
            if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
                return false;
            }
            return this.index == other.index;
        }
        return false;
    }
}

