/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.scheduler.EventJob;
import org.nuxeo.ecm.core.scheduler.Schedule;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerServiceImpl
extends DefaultComponent
implements SchedulerService {
    private static final Log log = LogFactory.getLog(SchedulerServiceImpl.class);
    protected RuntimeContext bundle;
    protected Scheduler scheduler;
    protected boolean applicationStarted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(ComponentContext context) throws Exception {
        String[] jobs;
        log.debug((Object)"Activate");
        this.bundle = context.getRuntimeContext();
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        URL cfg = context.getRuntimeContext().getResource("config/quartz.properties");
        if (cfg != null) {
            InputStream stream = cfg.openStream();
            try {
                schedulerFactory.initialize(stream);
            }
            finally {
                stream.close();
            }
        } else {
            Properties props = new Properties();
            props.put("org.quartz.scheduler.instanceName", "Quartz");
            props.put("org.quartz.scheduler.threadName", "Quartz_Scheduler");
            props.put("org.quartz.scheduler.instanceId", "NON_CLUSTERED");
            props.put("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            props.put("org.quartz.scheduler.skipUpdateCheck", "true");
            props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
            props.put("org.quartz.threadPool.threadCount", "1");
            props.put("org.quartz.threadPool.threadPriority", "4");
            props.put("org.quartz.threadPool.makeThreadsDaemons", "true");
            schedulerFactory.initialize(props);
        }
        this.scheduler = schedulerFactory.getScheduler();
        this.scheduler.start();
        for (String job : jobs = this.scheduler.getJobNames("nuxeo")) {
            this.unregisterSchedule(job);
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        log.debug((Object)"Deactivate");
        this.scheduler.shutdown();
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        this.applicationStarted = true;
    }

    @Override
    public boolean hasApplicationStarted() {
        return this.applicationStarted;
    }

    public void registerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            Schedule schedule = (Schedule)contrib;
            this.registerSchedule(schedule);
        }
    }

    public void unregisterExtension(Extension extension) {
    }

    public RuntimeContext getContext() {
        return this.bundle;
    }

    @Override
    public void registerSchedule(Schedule schedule) {
        this.registerSchedule(schedule, null);
    }

    @Override
    public void registerSchedule(Schedule schedule, Map<String, Serializable> parameters) {
        CronTrigger trigger;
        log.info((Object)("Registering " + schedule));
        JobDetail job = new JobDetail(schedule.getId(), "nuxeo", EventJob.class);
        JobDataMap map = job.getJobDataMap();
        map.put("eventId", schedule.getEventId());
        map.put("eventCategory", schedule.getEventCategory());
        map.put("username", schedule.getUsername());
        if (parameters != null) {
            map.putAll(parameters);
        }
        try {
            trigger = new CronTrigger(schedule.getId(), "nuxeo", schedule.getCronExpression());
        }
        catch (ParseException e) {
            log.error((Object)String.format("invalid cron expresion '%s' for schedule '%s'", schedule.getCronExpression(), schedule.getId()), (Throwable)e);
            return;
        }
        try {
            this.scheduler.scheduleJob(job, (Trigger)trigger);
        }
        catch (ObjectAlreadyExistsException e) {
        }
        catch (SchedulerException e) {
            log.error((Object)String.format("failed to schedule job with id '%s': %s", schedule.getId(), e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean unregisterSchedule(String scheduleId) {
        log.info((Object)("Unregistering schedule with id" + scheduleId));
        try {
            return this.scheduler.deleteJob(scheduleId, "nuxeo");
        }
        catch (SchedulerException e) {
            log.error((Object)String.format("failed to unschedule job with '%s': %s", scheduleId, e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean unregisterSchedule(Schedule schedule) {
        return this.unregisterSchedule(schedule.getId());
    }
}

