/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.WorkQueueDescriptorRegistry;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WorkManagerImpl
extends DefaultComponent
implements WorkManager {
    private static final Log log = LogFactory.getLog(WorkManagerImpl.class);
    public static final String DEFAULT_QUEUE_ID = "default";
    public static final String DEFAULT_CATEGORY = "default";
    protected static final String QUEUES_EP = "queues";
    protected WorkQueueDescriptorRegistry workQueueDescriptors;
    protected static final int DEFAULT_MAX_POOL_SIZE = 4;
    protected Map<String, WorkThreadPoolExecutor> executors;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.workQueueDescriptors = new WorkQueueDescriptorRegistry();
        this.init();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.shutdown(1L, TimeUnit.SECONDS);
        this.workQueueDescriptors = null;
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (QUEUES_EP.equals(extensionPoint)) {
            WorkQueueDescriptor workQueueDescriptor = (WorkQueueDescriptor)contribution;
            log.info((Object)("Registered work queue " + workQueueDescriptor.id));
            this.workQueueDescriptors.addContribution(workQueueDescriptor);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (QUEUES_EP.equals(extensionPoint)) {
            WorkQueueDescriptor workQueueDescriptor = (WorkQueueDescriptor)contribution;
            log.info((Object)("Unregistered work queue " + workQueueDescriptor.id));
            this.workQueueDescriptors.removeContribution(workQueueDescriptor);
        }
    }

    @Override
    public List<String> getWorkQueueIds() {
        return this.workQueueDescriptors.getQueueIds();
    }

    @Override
    public WorkQueueDescriptor getWorkQueueDescriptor(String queueId) {
        return this.workQueueDescriptors.get(queueId);
    }

    @Override
    public String getCategoryQueueId(String category) {
        String queueId;
        if (category == null) {
            category = "default";
        }
        if ((queueId = this.workQueueDescriptors.getQueueId(category)) == null) {
            queueId = "default";
        }
        return queueId;
    }

    @Override
    public void init() {
        this.executors = new HashMap<String, WorkThreadPoolExecutor>();
    }

    protected synchronized boolean hasExecutor(String queueId) {
        return this.executors.containsKey(queueId);
    }

    protected synchronized WorkThreadPoolExecutor removeExecutor(String queueId) {
        return this.executors.remove(queueId);
    }

    protected synchronized WorkThreadPoolExecutor getExecutor(String queueId) {
        WorkQueueDescriptor workQueueDescriptor = this.workQueueDescriptors.get(queueId);
        if (workQueueDescriptor == null) {
            throw new IllegalArgumentException("No such work queue: " + queueId);
        }
        WorkThreadPoolExecutor executor = this.executors.get(queueId);
        if (executor == null) {
            NamedThreadFactory threadFactory = new NamedThreadFactory("Nuxeo-Work-" + queueId + "-");
            int maxPoolSize = workQueueDescriptor.maxThreads;
            if (maxPoolSize <= 0) {
                workQueueDescriptor.maxThreads = maxPoolSize = 4;
            }
            executor = new WorkThreadPoolExecutor(maxPoolSize, maxPoolSize, 0L, TimeUnit.SECONDS, this.newBlockingQueue(workQueueDescriptor.usePriority), threadFactory);
            this.executors.put(queueId, executor);
        }
        return executor;
    }

    protected BlockingQueue<Runnable> newBlockingQueue(boolean usePriority) {
        if (usePriority) {
            return new PriorityBlockingQueue<Runnable>();
        }
        return new LinkedBlockingQueue<Runnable>();
    }

    @Override
    public boolean shutdownQueue(String queueId, long timeout, TimeUnit unit) throws InterruptedException {
        WorkThreadPoolExecutor executor = this.getExecutor(queueId);
        boolean terminated = this.shutdownExecutors(Collections.singleton(executor), timeout, unit);
        this.removeExecutor(queueId);
        return terminated;
    }

    @Override
    public synchronized boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executors == null) {
            return true;
        }
        ArrayList<WorkThreadPoolExecutor> executorList = new ArrayList<WorkThreadPoolExecutor>(this.executors.values());
        this.executors = null;
        return this.shutdownExecutors(executorList, timeout, unit);
    }

    protected boolean shutdownExecutors(Collection<WorkThreadPoolExecutor> list, long timeout, TimeUnit unit) throws InterruptedException {
        for (WorkThreadPoolExecutor executor : list) {
            executor.shutdownAndSuspend();
        }
        long t0 = System.currentTimeMillis();
        long delay = unit.toMillis(timeout);
        boolean terminated = true;
        for (WorkThreadPoolExecutor executor : list) {
            if (executor.awaitTerminationOrSave(this.remainingMillis(t0, delay), TimeUnit.MILLISECONDS)) continue;
            terminated = false;
            executor.shutdownNow();
        }
        return terminated;
    }

    protected long remainingMillis(long t0, long delay) {
        long d = System.currentTimeMillis() - t0;
        if (d > delay) {
            return 0L;
        }
        return delay - d;
    }

    @Override
    public void schedule(Work work) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, false);
    }

    @Override
    public void schedule(Work work, boolean afterCommit) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, afterCommit);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling) {
        this.schedule(work, scheduling, false);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling, boolean afterCommit) {
        if (work.getState() != Work.State.SCHEDULED) {
            throw new IllegalStateException(String.valueOf((Object)work.getState()));
        }
        String queueId = this.getCategoryQueueId(work.getCategory());
        log.debug((Object)("Scheduling work: " + work + " using queue: " + queueId));
        WorkThreadPoolExecutor executor = this.getExecutor(queueId);
        switch (scheduling) {
            case ENQUEUE: {
                break;
            }
            case CANCEL_SCHEDULED: {
                executor.cancelScheduled(work);
                break;
            }
            case IF_NOT_SCHEDULED: 
            case IF_NOT_RUNNING: 
            case IF_NOT_RUNNING_OR_SCHEDULED: {
                if (executor.find(work, scheduling.state, true, null) == null) break;
                work.setCanceled();
                return;
            }
        }
        executor.execute(work, afterCommit);
    }

    @Override
    public Work find(Work work, Work.State state, boolean useEquals, int[] pos) {
        String queueId = this.getCategoryQueueId(work.getCategory());
        return this.getExecutor(queueId).find(work, state, useEquals, pos);
    }

    @Override
    public List<Work> listWork(String queueId, Work.State state) {
        if (state == null) {
            return this.getExecutor(queueId).getNonCompleted();
        }
        switch (state) {
            case SCHEDULED: {
                return this.getExecutor(queueId).getScheduled();
            }
            case RUNNING: {
                return this.getExecutor(queueId).getRunning();
            }
            case COMPLETED: {
                return this.getExecutor(queueId).getCompleted();
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public int getNonCompletedWorkSize(String queueId) {
        return this.getExecutor(queueId).getNonCompletedWorkSize();
    }

    @Override
    public boolean awaitCompletion(String queueId, long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitCompletion(Collections.singleton(queueId), timeout, unit);
    }

    @Override
    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitCompletion(this.getWorkQueueIds(), timeout, unit);
    }

    protected boolean awaitCompletion(Collection<String> queueIds, long timeout, TimeUnit unit) throws InterruptedException {
        long t0 = System.currentTimeMillis();
        long delay = unit.toMillis(timeout);
        while (true) {
            boolean completed = true;
            for (String queueId : queueIds) {
                if (this.getNonCompletedWorkSize(queueId) == 0) continue;
                completed = false;
                break;
            }
            if (completed) {
                return true;
            }
            if (System.currentTimeMillis() - t0 > delay) {
                return false;
            }
            Thread.sleep(50L);
        }
    }

    @Override
    public void clearCompletedWork(String queueId) {
        this.getExecutor(queueId).clearCompleted();
    }

    @Override
    public synchronized void clearCompletedWork(long completionTime) {
        for (WorkThreadPoolExecutor executor : this.executors.values()) {
            executor.clearCompleted(completionTime);
        }
    }

    @Override
    public synchronized void cleanup() {
        log.debug((Object)"Clearing old completed work");
        for (Map.Entry<String, WorkThreadPoolExecutor> es : this.executors.entrySet()) {
            String queueId = es.getKey();
            WorkThreadPoolExecutor executor = es.getValue();
            WorkQueueDescriptor descr = this.workQueueDescriptors.get(queueId);
            long delay = (long)descr.clearCompletedAfterSeconds * 1000L;
            if (delay <= 0L) continue;
            long completionTime = System.currentTimeMillis() - delay;
            executor.clearCompleted(completionTime);
        }
    }

    public static class WorkThreadPoolExecutor
    extends ThreadPoolExecutor {
        protected Object monitor = new Object();
        protected WorkList scheduledAfterCommit = new WorkList();
        protected WorkList scheduled = new WorkList();
        protected WorkList running = new WorkList();
        protected WorkList completed = new WorkList();
        protected WorkList suspended = new WorkList();

        public WorkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> queue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, threadFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancelScheduled(Work work) {
            boolean removed = false;
            while (this.getQueue().remove(work)) {
                removed = true;
            }
            if (removed) {
                Object object = this.monitor;
                synchronized (object) {
                    Work w;
                    Iterator it = this.scheduledAfterCommit.iterator();
                    while (it.hasNext()) {
                        w = (Work)it.next();
                        if (!work.equals(w)) continue;
                        it.remove();
                        w.setCanceled();
                    }
                    it = this.scheduled.iterator();
                    while (it.hasNext()) {
                        w = (Work)it.next();
                        if (!work.equals(w)) continue;
                        it.remove();
                        w.setCanceled();
                    }
                }
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelScheduledAfterCommit(Work work) {
            boolean removed;
            Object object = this.monitor;
            synchronized (object) {
                removed = this.scheduledAfterCommit.remove(work);
            }
            if (removed) {
                work.setCanceled();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Work find(Work work, Work.State state, boolean useEquals, int[] pos) {
            LinkedList<WorkList> queues = new LinkedList<WorkList>();
            if (state == null) {
                queues.add(this.running);
                queues.add(this.scheduled);
                queues.add(this.scheduledAfterCommit);
            } else if (state == Work.State.RUNNING) {
                queues.add(this.running);
            } else if (state == Work.State.SCHEDULED) {
                queues.add(this.scheduled);
                queues.add(this.scheduledAfterCommit);
            } else if (state == Work.State.COMPLETED) {
                queues.add(this.completed);
            } else {
                throw new IllegalArgumentException(String.valueOf((Object)state));
            }
            Object object = this.monitor;
            synchronized (object) {
                for (List list : queues) {
                    int i = -1;
                    for (Work w : list) {
                        ++i;
                        boolean found = useEquals ? w.equals(work) : w == work;
                        if (!found) continue;
                        if (pos != null) {
                            pos[0] = i;
                        }
                        return w;
                    }
                }
            }
            if (pos != null) {
                pos[0] = -1;
            }
            return null;
        }

        @Override
        public void execute(Runnable r) {
            this.execute((Work)r, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Work work, boolean afterCommit) {
            block13: {
                if (afterCommit) {
                    TransactionManager transactionManager;
                    try {
                        transactionManager = TransactionHelper.lookupTransactionManager();
                    }
                    catch (NamingException e) {
                        transactionManager = null;
                    }
                    if (transactionManager != null) {
                        try {
                            Transaction transaction = transactionManager.getTransaction();
                            if (transaction == null || transaction.getStatus() != 0) break block13;
                            transaction.registerSynchronization((Synchronization)new WorkSchedulingSynchronization(work, this));
                            Object object = this.monitor;
                            synchronized (object) {
                                this.scheduledAfterCommit.add(work);
                            }
                            return;
                        }
                        catch (SystemException e) {
                        }
                        catch (RollbackException e) {
                            // empty catch block
                        }
                    }
                }
            }
            Object object = this.monitor;
            synchronized (object) {
                this.scheduled.add(work);
            }
            super.execute(work);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCommit(Work work) {
            boolean removed;
            Object object = this.monitor;
            synchronized (object) {
                removed = this.scheduledAfterCommit.remove(work);
                if (removed) {
                    this.scheduled.add(work);
                }
            }
            if (removed) {
                super.execute(work);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Object object = this.monitor;
            synchronized (object) {
                Work work = (Work)r;
                this.scheduled.remove(work);
                this.running.add(work);
                work.beforeRun();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Object object = this.monitor;
            synchronized (object) {
                Work work = (Work)r;
                work.afterRun(t == null);
                this.running.remove(work);
                if (work.getState() == Work.State.SUSPENDED) {
                    this.suspended.add(work);
                } else {
                    this.completed.add(work);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void suspendFromQueue(Runnable r) {
            Work work = (Work)r;
            work.suspend();
            if (work.getState() != Work.State.SUSPENDED) {
                log.error((Object)("Work failed to suspend from queue on shutdown: " + work));
                return;
            }
            Object object = this.monitor;
            synchronized (object) {
                this.scheduled.remove(work);
                this.suspended.add(work);
            }
        }

        public void shutdownAndSuspend() {
            this.setRejectedExecutionHandler(SuspendPolicy.INSTANCE);
            this.shutdown();
            this.suspend();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean awaitTerminationOrSave(long timeout, TimeUnit unit) throws InterruptedException {
            ArrayList<Work> toSave;
            boolean terminated = this.awaitTermination(timeout, unit);
            if (!terminated) {
                ArrayList toSuspend = new ArrayList();
                this.getQueue().drainTo(toSuspend);
                for (Runnable r : toSuspend) {
                    this.suspendFromQueue(r);
                }
            }
            Iterator i$ = this.monitor;
            synchronized (i$) {
                toSave = new ArrayList<Work>(this.suspended);
                this.suspended.clear();
            }
            for (Work work : toSave) {
                if (work.getState() != Work.State.SUSPENDED) {
                    log.error((Object)("Work in suspended queue but not suspended: " + work));
                    continue;
                }
                Map<String, Serializable> data = work.getData();
            }
            return terminated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspend() {
            Object object = this.monitor;
            synchronized (object) {
                for (Work work : this.running) {
                    work.suspend();
                }
                for (Work work : this.scheduled) {
                    work.suspend();
                }
                for (Work work : this.scheduledAfterCommit) {
                    work.suspend();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Work> getScheduled() {
            Object object = this.monitor;
            synchronized (object) {
                ArrayList<Work> list = new ArrayList<Work>(this.scheduled);
                list.addAll(this.scheduledAfterCommit);
                return list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Work> getRunning() {
            Object object = this.monitor;
            synchronized (object) {
                return new ArrayList<Work>(this.running);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Work> getCompleted() {
            Object object = this.monitor;
            synchronized (object) {
                return new ArrayList<Work>(this.completed);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Work> getNonCompleted() {
            Object object = this.monitor;
            synchronized (object) {
                ArrayList<Work> list = new ArrayList<Work>(this.running.size() + this.scheduled.size());
                list.addAll(this.running);
                list.addAll(this.scheduled);
                list.addAll(this.scheduledAfterCommit);
                return list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNonCompletedWorkSize() {
            Object object = this.monitor;
            synchronized (object) {
                return this.scheduled.size() + this.scheduledAfterCommit.size() + this.running.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCompleted() {
            Object object = this.monitor;
            synchronized (object) {
                this.completed.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCompleted(long completionTime) {
            if (completionTime <= 0L) {
                this.clearCompleted();
                return;
            }
            Object object = this.monitor;
            synchronized (object) {
                Iterator it = this.completed.iterator();
                while (it.hasNext()) {
                    Work work = (Work)it.next();
                    if (work.getCompletionTime() >= completionTime) continue;
                    it.remove();
                }
            }
        }
    }

    public static class WorkList
    extends LinkedList<Work> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean remove(Object o) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Work w = (Work)it.next();
                if (w != o) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    public static class WorkSchedulingSynchronization
    implements Synchronization {
        protected final Work work;
        protected final WorkThreadPoolExecutor executor;

        public WorkSchedulingSynchronization(Work work, WorkThreadPoolExecutor executor) {
            this.work = work;
            this.executor = executor;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (this.work.getState() != Work.State.SCHEDULED) {
                return;
            }
            if (status == 3) {
                this.executor.afterCommit(this.work);
            } else if (status == 4) {
                this.executor.cancelScheduledAfterCommit(this.work);
            } else {
                log.error((Object)("Unexpected status after completion: " + status));
            }
        }
    }

    public static class SuspendPolicy
    implements RejectedExecutionHandler {
        public static final SuspendPolicy INSTANCE = new SuspendPolicy();

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            ((WorkThreadPoolExecutor)executor).suspendFromQueue(r);
        }
    }

    public static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            return thread;
        }
    }
}

