/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.packages.DownloadingPackageSource;
import org.nuxeo.connect.packages.LocalPackageSource;
import org.nuxeo.connect.packages.PackageComparator;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.RemotePackageSource;
import org.nuxeo.connect.packages.VersionPackageComparator;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.DependencyResolver;
import org.nuxeo.connect.packages.dependencies.LegacyDependencyResolver;
import org.nuxeo.connect.packages.dependencies.P2CUDFDependencyResolver;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.VersionRange;
import org.nuxeo.connect.update.task.Task;

public class PackageManagerImpl
implements PackageManager {
    protected static final Log log = LogFactory.getLog(PackageManagerImpl.class);
    protected List<PackageSource> localSources = new ArrayList<PackageSource>();
    protected List<PackageSource> remoteSources = new ArrayList<PackageSource>();
    protected List<String> sourcesNames = new ArrayList<String>();
    protected Map<String, DownloadablePackage> cachedPackageList = null;
    protected DependencyResolver resolver;

    protected List<PackageSource> getAllSources() {
        ArrayList<PackageSource> allSources = new ArrayList<PackageSource>();
        allSources.addAll(this.remoteSources);
        allSources.addAll(this.localSources);
        return allSources;
    }

    public PackageManagerImpl() {
        this.registerSource(new RemotePackageSource(), false);
        this.registerSource(new DownloadingPackageSource(), true);
        this.registerSource(new LocalPackageSource(), true);
        this.setResolver("p2cudf");
    }

    @Override
    public void setResolver(String resolverType) {
        if ("p2cudf".equals(resolverType)) {
            this.resolver = new P2CUDFDependencyResolver(this);
        } else if ("legacy".equals(resolverType)) {
            this.resolver = new LegacyDependencyResolver(this);
        } else {
            log.warn((Object)("Resolver " + resolverType + "is not supported - fallback on default resolver " + "p2cudf"));
            this.resolver = new P2CUDFDependencyResolver(this);
        }
    }

    public void resetSources() {
        this.localSources.clear();
        this.remoteSources.clear();
        this.sourcesNames.clear();
        if (this.cachedPackageList != null) {
            this.cachedPackageList.clear();
        }
    }

    protected List<DownloadablePackage> doMergePackages(List<PackageSource> sources, PackageType type, String targetPlatform) {
        List<DownloadablePackage> allPackages = this.getAllPackages(sources, type, targetPlatform);
        HashMap packagesByIdAndTargetPlatform = new HashMap();
        for (DownloadablePackage pkg : allPackages) {
            String[] targetPlatforms;
            String[] stringArray;
            if (targetPlatform != null && !Arrays.asList(pkg.getTargetPlatforms()).contains(targetPlatform)) continue;
            if (targetPlatform != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = targetPlatform;
            } else {
                stringArray = targetPlatforms = pkg.getTargetPlatforms();
            }
            if (targetPlatform != null) {
                targetPlatforms = new String[]{targetPlatform};
            } else {
                targetPlatforms = pkg.getTargetPlatforms();
                if (targetPlatforms == null) {
                    targetPlatforms = new String[]{null};
                }
            }
            for (String tp : targetPlatforms) {
                String key;
                HashMap<String, DownloadablePackage> packagesById = (HashMap<String, DownloadablePackage>)packagesByIdAndTargetPlatform.get(tp);
                if (packagesById == null) {
                    packagesById = new HashMap<String, DownloadablePackage>();
                    packagesByIdAndTargetPlatform.put(tp, packagesById);
                }
                if (packagesById.containsKey(key = pkg.getId())) {
                    if (!pkg.getVersion().greaterThan(((DownloadablePackage)packagesById.get(key)).getVersion())) continue;
                    packagesById.put(key, pkg);
                    continue;
                }
                packagesById.put(key, pkg);
            }
        }
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (Map packagesById : packagesByIdAndTargetPlatform.values()) {
            for (DownloadablePackage pkg : packagesById.values()) {
                if (result.contains(pkg)) continue;
                result.add(pkg);
            }
        }
        return result;
    }

    protected List<DownloadablePackage> getAllPackages(List<PackageSource> sources, PackageType type) {
        return this.getAllPackages(sources, type, null);
    }

    protected List<DownloadablePackage> getAllPackages(List<PackageSource> sources, PackageType type, String targetPlatform) {
        Map<String, DownloadablePackage> packagesById = this.getAllPackagesByID(sources, type, targetPlatform);
        return new ArrayList<DownloadablePackage>(packagesById.values());
    }

    protected Map<String, DownloadablePackage> getAllPackagesByID(List<PackageSource> sources, PackageType type) {
        return this.getAllPackagesByID(sources, type, null);
    }

    protected Map<String, DownloadablePackage> getAllPackagesByID(List<PackageSource> sources, PackageType type, String targetPlatform) {
        HashMap<String, DownloadablePackage> packagesById = new HashMap<String, DownloadablePackage>();
        for (PackageSource source : sources) {
            List<DownloadablePackage> packages = null;
            packages = type == null ? source.listPackages() : source.listPackages(type);
            for (DownloadablePackage pkg : packages) {
                if (targetPlatform != null && !Arrays.asList(pkg.getTargetPlatforms()).contains(targetPlatform)) continue;
                packagesById.put(pkg.getId(), pkg);
            }
        }
        return packagesById;
    }

    @Override
    public Map<String, DownloadablePackage> getAllPackagesByID() {
        return this.getAllPackagesByID(this.getAllSources(), null);
    }

    @Override
    public Map<String, List<DownloadablePackage>> getAllPackagesByName() {
        return this.getAllPackagesByName(this.getAllSources(), null);
    }

    protected Map<String, List<DownloadablePackage>> getAllPackagesByName(List<PackageSource> sources, PackageType type) {
        HashMap<String, List<DownloadablePackage>> packagesByName = new HashMap<String, List<DownloadablePackage>>();
        for (PackageSource source : sources) {
            List<DownloadablePackage> packages = null;
            packages = type == null ? source.listPackages() : source.listPackages(type);
            for (DownloadablePackage pkg : packages) {
                List<DownloadablePackage> pkgsForName;
                if (!packagesByName.containsKey(pkg.getName())) {
                    pkgsForName = new ArrayList();
                    packagesByName.put(pkg.getName(), pkgsForName);
                } else {
                    pkgsForName = (List)packagesByName.get(pkg.getName());
                }
                pkgsForName.add(pkg);
            }
        }
        return packagesByName;
    }

    @Override
    public List<DownloadablePackage> findRemotePackages(String packageName) {
        ArrayList<DownloadablePackage> pkgs = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.remoteSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(packageName)) continue;
                pkgs.add(pkg);
            }
        }
        return pkgs;
    }

    @Override
    public List<Version> findLocalPackageVersions(String packageName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(packageName)) continue;
                versions.add(pkg.getVersion());
            }
        }
        return versions;
    }

    @Override
    public List<Version> findLocalPackageInstalledVersions(String packageName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(packageName) || pkg.getState() < PackageState.INSTALLING.getValue()) continue;
                versions.add(pkg.getVersion());
            }
        }
        return versions;
    }

    @Override
    public DownloadablePackage findPackageById(String packageId) {
        DownloadablePackage pkg = this.findPackageById(packageId, this.localSources);
        if (pkg == null) {
            pkg = this.findPackageById(packageId, this.remoteSources);
        }
        return pkg;
    }

    protected DownloadablePackage findPackageById(String packageId, List<PackageSource> sources) {
        for (PackageSource source : sources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getId().equals(packageId)) continue;
                return pkg;
            }
        }
        return null;
    }

    @Override
    public List<Version> getPreferedVersions(String pkgName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        ArrayList<Version> installedVersions = new ArrayList<Version>();
        ArrayList<Version> localVersions = new ArrayList<Version>();
        ArrayList<Version> remoteVersions = new ArrayList<Version>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(pkgName)) continue;
                if (pkg.getState() == PackageState.INSTALLED.getValue()) {
                    installedVersions.add(pkg.getVersion());
                    continue;
                }
                localVersions.add(pkg.getVersion());
            }
        }
        for (PackageSource source : this.remoteSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(pkgName)) continue;
                remoteVersions.add(pkg.getVersion());
            }
        }
        Collections.sort(localVersions);
        Collections.sort(remoteVersions);
        versions.addAll(installedVersions);
        versions.addAll(localVersions);
        versions.addAll(remoteVersions);
        return versions;
    }

    @Override
    public List<Version> getAvailableVersion(String pkgName, VersionRange range, String targetPlatform) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (PackageSource source : this.getAllSources()) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(pkgName) || !range.matchVersion(pkg.getVersion()) || !TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg, targetPlatform) || versions.contains(pkg.getVersion())) continue;
                versions.add(pkg.getVersion());
            }
        }
        return versions;
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        return this.listPackages(null, null);
    }

    @Override
    public List<DownloadablePackage> listPackages(String targetPlatform) {
        return this.listPackages(null, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        return this.listPackages(type, null);
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType pkgType, String targetPlatform) {
        return this.doMergePackages(this.getAllSources(), pkgType, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> searchPackages(String searchExpr) {
        return null;
    }

    @Override
    public void registerSource(PackageSource source, boolean local) {
        String name = source.getName();
        if (!this.sourcesNames.contains(name)) {
            if (local) {
                this.localSources.add(source);
            } else {
                this.remoteSources.add(source);
            }
        }
    }

    @Override
    public List<DownloadablePackage> listInstalledPackages() {
        ArrayList<DownloadablePackage> res = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (pkg.getState() < PackageState.INSTALLING.getValue()) continue;
                res.add(pkg);
            }
        }
        Collections.sort(res, new VersionPackageComparator());
        return res;
    }

    @Override
    public List<DownloadablePackage> listRemotePackages() {
        return this.listRemotePackages(null, null);
    }

    @Override
    public List<DownloadablePackage> listRemotePackages(PackageType pkgType) {
        return this.listRemotePackages(pkgType, null);
    }

    @Override
    public List<DownloadablePackage> listRemotePackages(PackageType pkgType, String targetPlatform) {
        List<DownloadablePackage> result = this.doMergePackages(this.remoteSources, pkgType, targetPlatform);
        Collections.sort(result, new VersionPackageComparator());
        return result;
    }

    @Override
    public List<DownloadablePackage> listLocalPackages() {
        return this.listLocalPackages(null);
    }

    @Override
    public List<DownloadablePackage> listLocalPackages(PackageType type) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        ArrayList<String> pkgIds = new ArrayList<String>();
        for (PackageSource source : this.localSources) {
            List<DownloadablePackage> pkgs = null;
            pkgs = type == null ? source.listPackages() : source.listPackages(type);
            for (DownloadablePackage pkg : pkgs) {
                if (pkgIds.contains(pkg.getId())) continue;
                pkgIds.add(pkg.getId());
                result.add(pkg);
            }
        }
        Collections.sort(result, new VersionPackageComparator());
        return result;
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages() {
        return this.listUpdatePackages(null, null);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages(PackageType type) {
        return this.listUpdatePackages(type, null);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages(String targetPlatform) {
        return this.listUpdatePackages(null, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages(PackageType type, String targetPlatform) {
        List<DownloadablePackage> localPackages = this.getAllPackages(this.localSources, type);
        List<DownloadablePackage> availablePackages = this.doMergePackages(this.getAllSources(), type, targetPlatform);
        ArrayList<DownloadablePackage> toUpdate = new ArrayList<DownloadablePackage>();
        ArrayList<String> toUpdateIds = new ArrayList<String>();
        block0: for (DownloadablePackage pkg : localPackages) {
            if (pkg.getState() != PackageState.INSTALLING.getValue() && pkg.getState() != PackageState.INSTALLED.getValue() && pkg.getState() != PackageState.STARTED.getValue()) continue;
            for (DownloadablePackage availablePackage : availablePackages) {
                if (!availablePackage.getName().equals(pkg.getName())) continue;
                if (availablePackage.getVersion() != null) {
                    if (!availablePackage.getVersion().greaterThan(pkg.getVersion())) continue block0;
                    toUpdate.add(availablePackage);
                    toUpdateIds.add(availablePackage.getId());
                    continue block0;
                }
                log.warn((Object)("Package " + availablePackage.getId() + " has a null version"));
                continue block0;
            }
        }
        if (type == null || type == PackageType.HOT_FIX) {
            List<DownloadablePackage> hotFixes = this.doMergePackages(this.getAllSources(), PackageType.HOT_FIX, targetPlatform);
            for (DownloadablePackage pkg : hotFixes) {
                if (toUpdateIds.contains(pkg.getId())) continue;
                boolean alreadyInLocal = false;
                for (DownloadablePackage lpkg : localPackages) {
                    if (!lpkg.getName().equals(pkg.getName())) continue;
                    if (!lpkg.getVersion().greaterOrEqualThan(pkg.getVersion()) || lpkg.getState() != PackageState.INSTALLING.getValue() && lpkg.getState() != PackageState.INSTALLED.getValue() && lpkg.getState() != PackageState.STARTED.getValue()) break;
                    alreadyInLocal = true;
                    break;
                }
                if (alreadyInLocal) continue;
                toUpdate.add(0, pkg);
            }
        }
        LinkedHashSet updateSet = new LinkedHashSet(toUpdate);
        toUpdate = new ArrayList(updateSet);
        Collections.sort(toUpdate, new VersionPackageComparator());
        return toUpdate;
    }

    @Override
    public List<DownloadablePackage> listPrivatePackages(PackageType pkgType, String targetPlatform) {
        List<DownloadablePackage> allPackages = this.getAllPackages(this.getAllSources(), pkgType, targetPlatform);
        Collections.sort(allPackages, new VersionPackageComparator());
        ArrayList<DownloadablePackage> allPrivatePackages = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage downloadablePackage : allPackages) {
            if (downloadablePackage.getVisibility() != PackageVisibility.PRIVATE) continue;
            allPrivatePackages.add(downloadablePackage);
        }
        return allPrivatePackages;
    }

    @Override
    public List<DownloadablePackage> listPrivatePackages(String targetPlatform) {
        return this.listPrivatePackages(null, targetPlatform);
    }

    @Override
    public DownloadingPackage download(String packageId) throws Exception {
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        return crs.getConnector().getDownload(packageId);
    }

    @Override
    public List<DownloadingPackage> download(List<String> packageIds) throws Exception {
        ArrayList<DownloadingPackage> downloadings = new ArrayList<DownloadingPackage>();
        for (String packageId : packageIds) {
            downloadings.add(this.download(packageId));
        }
        return downloadings;
    }

    @Override
    public void install(String packageId, Map<String, String> params) throws Exception {
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        if (pus == null) {
            if (!NuxeoConnectClient.isTestModeSet()) {
                log.error((Object)"Can not locate PackageUpdateService, exiting");
            }
            return;
        }
        LocalPackage pkg = pus.getPackage(packageId);
        Task installationTask = pkg.getInstallTask();
        installationTask.validate();
        installationTask.run(params);
    }

    @Override
    public void install(List<String> packageIds, Map<String, String> params) throws Exception {
        for (String packageId : packageIds) {
            this.install(packageId, params);
        }
    }

    protected void invalidateCache() {
        this.cachedPackageList = null;
    }

    protected Map<String, DownloadablePackage> getCachedPackageList() {
        if (this.cachedPackageList == null) {
            this.cachedPackageList = new HashMap<String, DownloadablePackage>();
        }
        for (DownloadablePackage pkg : this.listPackages()) {
            this.cachedPackageList.put(pkg.getId(), pkg);
        }
        return this.cachedPackageList;
    }

    protected DownloadablePackage getPkgInList(List<DownloadablePackage> pkgs, String pkgId) {
        for (DownloadablePackage pkg : pkgs) {
            if (!pkgId.equals(pkg.getId())) continue;
            return pkg;
        }
        return null;
    }

    public DownloadablePackage getLocalPackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listLocalPackages();
        return this.getPkgInList(pkgs, pkgId);
    }

    public DownloadablePackage getRemotePackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listRemotePackages();
        return this.getPkgInList(pkgs, pkgId);
    }

    @Override
    public DownloadablePackage getPackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listAllPackages();
        DownloadablePackage pkg = this.getPkgInList(pkgs, pkgId);
        if (pkg == null) {
            List<DownloadablePackage> studioPkgs = this.listAllStudioRemotePackages();
            pkg = this.getPkgInList(studioPkgs, pkgId);
        }
        return pkg;
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> listRemoteOrLocalPackages() {
        return this.listRemoteOrLocalPackages(null, null);
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> listRemoteOrLocalPackages(PackageType pkgType) {
        return this.listRemoteOrLocalPackages(pkgType, null);
    }

    @Override
    public List<DownloadablePackage> listRemoteOrLocalPackages(String targetPlatform) {
        return this.listRemoteOrLocalPackages(null, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listRemoteOrLocalPackages(PackageType pkgType, String targetPlatform) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        List<DownloadablePackage> all = this.listPackages(pkgType, targetPlatform);
        List<DownloadablePackage> remotes = this.listRemotePackages(pkgType, targetPlatform);
        block0: for (DownloadablePackage pkg : all) {
            for (DownloadablePackage remote : remotes) {
                if (!remote.getId().equals(pkg.getId())) continue;
                result.add(pkg);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listAllStudioRemoteOrLocalPackages() {
        List<DownloadablePackage> remote = this.listAllStudioRemotePackages();
        List<DownloadablePackage> local = this.listLocalPackages(PackageType.STUDIO);
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : remote) {
            boolean found = false;
            for (DownloadablePackage lpkg : local) {
                if (!lpkg.getId().equals(pkg.getId())) continue;
                result.add(lpkg);
                found = true;
                break;
            }
            if (found) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> listOnlyRemotePackages() {
        return this.listOnlyRemotePackages(null, null);
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> listOnlyRemotePackages(PackageType pkgType) {
        return this.listOnlyRemotePackages(pkgType, null);
    }

    @Override
    public List<DownloadablePackage> listOnlyRemotePackages(String targetPlatform) {
        return this.listOnlyRemotePackages(null, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listOnlyRemotePackages(PackageType pkgType, String targetPlatform) {
        List<DownloadablePackage> result = this.listRemotePackages(pkgType, targetPlatform);
        List<DownloadablePackage> local = this.listLocalPackages(pkgType);
        block0: for (DownloadablePackage pkg : local) {
            for (DownloadablePackage remote : result) {
                if (!remote.getName().equals(pkg.getName())) continue;
                result.remove(remote);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listAllStudioRemotePackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.remoteSources) {
            List<DownloadablePackage> packages = source.listPackages(PackageType.STUDIO);
            result.addAll(packages);
        }
        return result;
    }

    @Override
    public void flushCache() {
        for (PackageSource source : this.getAllSources()) {
            source.flushCache();
        }
    }

    @Override
    public DependencyResolution resolveDependencies(String pkgId, String targetPlatform) {
        try {
            return this.resolver.resolve(pkgId, targetPlatform);
        }
        catch (DependencyException e) {
            return new DependencyResolution(e);
        }
    }

    @Override
    public DependencyResolution resolveDependencies(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform) {
        try {
            return this.resolver.resolve(pkgInstall, pkgRemove, pkgUpgrade, targetPlatform);
        }
        catch (DependencyException e) {
            return new DependencyResolution(e);
        }
    }

    @Override
    public List<DownloadablePackage> getUninstallDependencies(Package pkg, String targetPlatform) {
        ArrayList<DownloadablePackage> packagesToUninstall = new ArrayList<DownloadablePackage>();
        DependencyResolution resolution = this.resolveDependencies(null, Arrays.asList(pkg.getName()), null, targetPlatform);
        if (!resolution.isFailed() && !resolution.isEmpty()) {
            List<String> idsToRemove = resolution.getOrderedPackageIdsToRemove();
            idsToRemove.remove(pkg.getId());
            for (String pkgIdToRemove : idsToRemove) {
                packagesToUninstall.add(this.findPackageById(pkgIdToRemove, this.localSources));
            }
        }
        return packagesToUninstall;
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> getUninstallDependencies(Package pkg) {
        ArrayList<String> pkgNamesToRemove = new ArrayList<String>();
        List<DownloadablePackage> installedPackages = this.listInstalledPackages();
        int nbImpactedPackages = 0;
        pkgNamesToRemove.add(pkg.getName());
        while (pkgNamesToRemove.size() > nbImpactedPackages) {
            nbImpactedPackages = pkgNamesToRemove.size();
            block1: for (DownloadablePackage p : installedPackages) {
                if (pkgNamesToRemove.contains(p.getName())) continue;
                for (PackageDependency dep : p.getDependencies()) {
                    if (!pkgNamesToRemove.contains(dep.getName())) continue;
                    pkgNamesToRemove.add(p.getName());
                    continue block1;
                }
            }
        }
        pkgNamesToRemove.remove(pkg.getName());
        ArrayList<DownloadablePackage> packagesToUninstall = new ArrayList<DownloadablePackage>();
        for (String pkgName : pkgNamesToRemove) {
            for (Version v : this.findLocalPackageInstalledVersions(pkgName)) {
                DownloadablePackage p = this.getLocalPackage(pkgName + "-" + v.toString());
                packagesToUninstall.add(p);
            }
        }
        return packagesToUninstall;
    }

    @Override
    public List<DownloadablePackage> listAllPackages() {
        return this.getAllPackages(this.getAllSources(), null);
    }

    @Override
    public boolean isInstalled(Package pkg) {
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        if (pus == null) {
            if (!NuxeoConnectClient.isTestModeSet()) {
                log.error((Object)"Can not locate PackageUpdateService, set package as not installed.");
            }
            return false;
        }
        return pus.isStarted(pkg.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void order(DependencyResolution res) throws DependencyException {
        Map<String, DownloadablePackage> allPackagesByID = this.getAllPackagesByID();
        DependencyResolution dependencyResolution = res;
        synchronized (dependencyResolution) {
            if (!res.isSorted()) {
                res.sort(this);
            }
            List<String> installOrder = res.getOrderedPackageIdsToInstall();
            this.orderByDependencies(allPackagesByID, installOrder);
            List<String> removeOrder = res.getOrderedPackageIdsToRemove();
            this.orderByDependencies(allPackagesByID, removeOrder);
            Collections.reverse(removeOrder);
        }
    }

    private void orderByDependencies(Map<String, DownloadablePackage> allPackagesByID, List<String> orderedList) throws DependencyException {
        Map<String, DownloadablePackage> orderedMap = Collections.synchronizedMap(new LinkedHashMap());
        boolean hasChanged = true;
        HashSet<String> missingDeps = new HashSet<String>();
        while (!orderedList.isEmpty() && hasChanged) {
            hasChanged = false;
            for (String id : orderedList) {
                DownloadablePackage pkg = allPackagesByID.get(id);
                if (pkg.getDependencies().length == 0) {
                    orderedMap.put(id, pkg);
                    hasChanged = true;
                    continue;
                }
                boolean allSatisfied = true;
                for (PackageDependency pkgDep : pkg.getDependencies()) {
                    boolean satisfied = false;
                    for (Package orderedPkg : orderedMap.values()) {
                        if (!this.matchDependency(pkgDep, orderedPkg)) continue;
                        satisfied = true;
                        missingDeps.remove(pkgDep);
                        break;
                    }
                    if (!satisfied) {
                        for (Version version : this.findLocalPackageInstalledVersions(pkgDep.getName())) {
                            if (!pkgDep.getVersionRange().matchVersion(version)) continue;
                            satisfied = true;
                            missingDeps.remove(pkgDep);
                            break;
                        }
                    }
                    if (satisfied) continue;
                    allSatisfied = false;
                    missingDeps.add(pkgDep.toString());
                    break;
                }
                if (!allSatisfied) continue;
                orderedMap.put(id, pkg);
                hasChanged = true;
            }
            orderedList.removeAll(orderedMap.keySet());
        }
        if (!orderedList.isEmpty()) {
            throw new DependencyException(String.format("Couldn't order %s missing %s.", orderedList, missingDeps));
        }
        orderedList.addAll(orderedMap.keySet());
    }

    private boolean matchDependency(PackageDependency pkgDep, Package pkg) {
        boolean match;
        boolean bl = match = pkgDep.getName().equals(pkg.getName()) && pkgDep.getVersionRange().matchVersion(pkg.getVersion());
        if (!match && pkg.getProvides() != null) {
            for (PackageDependency provide : pkg.getProvides()) {
                if (!pkgDep.getName().equals(provide.getName()) || !pkgDep.getVersionRange().matchVersionRange(provide.getVersionRange())) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    @Override
    public void cancelDownload(String pkgId) {
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        cdm.removeDownloadingPackage(pkgId);
    }

    @Override
    public List<? extends Package> sort(List<? extends Package> pkgs) {
        Collections.sort(pkgs, new PackageComparator());
        return pkgs;
    }

    @Override
    public String getNonCompliant(List<String> packages, String targetPlatform) throws PackageException {
        for (String pkg : packages) {
            if (this.matchesPlatform(pkg, targetPlatform)) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public boolean matchesPlatform(String requestPkgStr, String targetPlatform) throws PackageException {
        Map<String, DownloadablePackage> allPackagesByID = this.getAllPackagesByID();
        Map<String, List<DownloadablePackage>> allPackagesByName = this.getAllPackagesByName();
        if (allPackagesByID.containsKey(requestPkgStr)) {
            return allPackagesByID.get(requestPkgStr).getTargetPlatforms().length == 0 || Arrays.asList(allPackagesByID.get(requestPkgStr).getTargetPlatforms()).contains(targetPlatform);
        }
        List<DownloadablePackage> allPackagesForName = allPackagesByName.get(requestPkgStr);
        if (allPackagesForName == null) {
            throw new PackageException("Package not found: " + requestPkgStr);
        }
        for (DownloadablePackage pkg : allPackagesForName) {
            if (!requestPkgStr.equals(pkg.getName()) || pkg.getTargetPlatforms().length != 0 && !Arrays.asList(pkg.getTargetPlatforms()).contains(targetPlatform)) continue;
            return true;
        }
        return false;
    }
}

