/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.storage.sql.FulltextParser;
import org.nuxeo.ecm.core.storage.sql.FulltextUpdaterWork;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public class FulltextExtractorWork
extends AbstractWork {
    private static final Log log = LogFactory.getLog(FulltextExtractorWork.class);
    private static final String ANY2TEXT = "any2text";
    protected static final String CATEGORY = "fulltextExtractor";
    protected static final String TITLE = "fulltextExtractor";
    protected String repositoryName;
    protected Set<String> ids;
    protected ModelFulltext fulltextInfo;
    protected Class<? extends FulltextParser> fulltextParserClass;
    protected FulltextParser fulltextParser;

    public FulltextExtractorWork(String repositoryName, Set<String> ids) {
        this.repositoryName = repositoryName;
        this.ids = ids;
    }

    public String getCategory() {
        return "fulltextExtractor";
    }

    public String getTitle() {
        return "fulltextExtractor";
    }

    public Collection<DocumentLocation> getDocuments() {
        ArrayList<DocumentLocation> docs = new ArrayList<DocumentLocation>(this.ids.size());
        for (String id : this.ids) {
            IdRef ref = new IdRef(id);
            DocumentLocationImpl doc = new DocumentLocationImpl(this.repositoryName, (DocumentRef)ref);
            docs.add((DocumentLocation)doc);
        }
        return docs;
    }

    public void work() throws Exception {
        if (this.ids.isEmpty()) {
            return;
        }
        this.initSession(this.repositoryName);
        if (this.session.getPrincipal() == null) {
            return;
        }
        this.fulltextInfo = RepositoryResolver.getModelFulltext(this.repositoryName);
        this.fulltextParserClass = RepositoryResolver.getFulltextParserClass(this.repositoryName);
        this.initFulltextParser();
        BlobsExtractor extractor = new BlobsExtractor();
        ArrayList<FulltextUpdaterWork.FulltextUpdaterInfo> infos = new ArrayList<FulltextUpdaterWork.FulltextUpdaterInfo>();
        int n = 0;
        this.setStatus("Extracting");
        for (String id : this.ids) {
            DocumentModel doc;
            this.setProgress(new Work.Progress((long)(++n), (long)this.ids.size()));
            IdRef docRef = new IdRef(id);
            if (!this.session.exists((DocumentRef)docRef) || (doc = this.session.getDocument((DocumentRef)docRef)).isProxy() || !this.fulltextInfo.isFulltextIndexable(doc.getType())) continue;
            for (String indexName : this.fulltextInfo.indexNames) {
                if (!this.fulltextInfo.indexesAllBinary.contains(indexName) && this.fulltextInfo.propPathsByIndexBinary.get(indexName) == null) continue;
                extractor.setExtractorProperties(this.fulltextInfo.propPathsByIndexBinary.get(indexName), this.fulltextInfo.propPathsExcludedByIndexBinary.get(indexName), this.fulltextInfo.indexesAllBinary.contains(indexName));
                List blobs = extractor.getBlobs(doc);
                String text = this.blobsToText(blobs, id);
                this.fulltextParser.setStrings(new ArrayList<String>());
                this.fulltextParser.parse(text, null);
                text = StringUtils.join(this.fulltextParser.getStrings(), (String)" ");
                FulltextUpdaterWork.FulltextUpdaterInfo info = new FulltextUpdaterWork.FulltextUpdaterInfo();
                info.jobId = doc.getId();
                info.indexName = indexName;
                info.text = text;
                infos.add(info);
            }
        }
        if (!infos.isEmpty()) {
            FulltextUpdaterWork work = new FulltextUpdaterWork(false, this.repositoryName, infos);
            ((WorkManager)Framework.getLocalService(WorkManager.class)).schedule((Work)work);
        }
        this.setStatus(null);
    }

    public void cleanUp(boolean ok, Exception e) {
        super.cleanUp(ok, e);
        this.fulltextInfo = null;
        this.fulltextParser = null;
        this.fulltextParserClass = null;
        this.ids = null;
    }

    protected void initFulltextParser() {
        this.fulltextParser = new FulltextParser();
        if (this.fulltextParserClass != null) {
            try {
                this.fulltextParser = this.fulltextParserClass.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)("Failed to instantiate " + this.fulltextParserClass.getCanonicalName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
        }
    }

    protected String blobsToText(List<Blob> blobs, String docId) {
        LinkedList<String> strings = new LinkedList<String>();
        for (Blob blob : blobs) {
            try {
                SimpleBlobHolder bh = new SimpleBlobHolder(blob);
                BlobHolder result = this.convert((BlobHolder)bh);
                if (result == null || (blob = result.getBlob()) == null) continue;
                String string = new String(blob.getByteArray(), "UTF-8");
                if (string.indexOf(0) >= 0) {
                    string = string.replace("\u0000", " ");
                }
                strings.add(string);
            }
            catch (Exception e) {
                String msg = "Could not extract fulltext of file '" + blob.getFilename() + "' for document: " + docId;
                log.warn((Object)msg);
                log.debug((Object)msg, (Throwable)e);
            }
        }
        return StringUtils.join(strings, (String)" ");
    }

    protected BlobHolder convert(BlobHolder blobHolder) throws ConversionException {
        ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
        if (conversionService == null) {
            log.debug((Object)"No ConversionService available");
            return null;
        }
        return conversionService.convert(ANY2TEXT, blobHolder, null);
    }
}

