/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

public interface RowMapper {
    public Serializable generateNewId() throws StorageException;

    public List<? extends RowId> read(Collection<RowId> var1, boolean var2) throws StorageException;

    public void write(RowBatch var1) throws StorageException;

    public Row readSimpleRow(RowId var1) throws StorageException;

    public Serializable[] readCollectionRowArray(RowId var1) throws StorageException;

    public List<Row> readSelectionRows(SelectionType var1, Serializable var2, Serializable var3, Serializable var4, boolean var5) throws StorageException;

    public CopyResult copy(IdWithTypes var1, Serializable var2, String var3, Row var4) throws StorageException;

    public List<NodeInfo> remove(NodeInfo var1) throws StorageException;

    public Invalidations.InvalidationsPair receiveInvalidations() throws StorageException;

    public void sendInvalidations(Invalidations var1) throws StorageException;

    public void clearCache();

    public void rollback(Xid var1) throws XAException;

    public static final class NodeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Serializable id;
        public final Serializable parentId;
        public final String primaryType;
        public final Boolean isProperty;
        public final Serializable versionSeriesId;
        public final Serializable targetId;

        public NodeInfo(Serializable id, Serializable parentId, String primaryType, Boolean isProperty, Serializable versionSeriesId, Serializable targetId) {
            this.id = id;
            this.parentId = parentId;
            this.primaryType = primaryType;
            this.isProperty = isProperty;
            this.versionSeriesId = versionSeriesId;
            this.targetId = targetId;
        }

        public NodeInfo(SimpleFragment hierFragment, SimpleFragment versionFragment, SimpleFragment proxyFragment) throws StorageException {
            Serializable ps;
            this.id = hierFragment.getId();
            this.parentId = hierFragment.get("parentid");
            this.primaryType = hierFragment.getString("primarytype");
            this.isProperty = (Boolean)hierFragment.get("isproperty");
            Serializable serializable = ps = proxyFragment == null ? null : proxyFragment.get("versionableid");
            if (ps == null) {
                this.versionSeriesId = versionFragment == null ? null : versionFragment.get("versionableid");
                this.targetId = null;
            } else {
                this.versionSeriesId = ps;
                this.targetId = proxyFragment.get("targetid");
            }
        }
    }

    public static final class CopyResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Serializable copyId;
        public final Invalidations invalidations;
        public final Set<Serializable> proxyIds;

        public CopyResult(Serializable copyId, Invalidations invalidations, Set<Serializable> proxyIds) {
            this.copyId = copyId;
            this.invalidations = invalidations;
            this.proxyIds = proxyIds;
        }
    }

    public static final class IdWithTypes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Serializable id;
        public final String primaryType;
        public final String[] mixinTypes;

        public IdWithTypes(Serializable id, String primaryType, String[] mixinTypes) {
            this.id = id;
            this.primaryType = primaryType;
            this.mixinTypes = mixinTypes;
        }

        public IdWithTypes(Node node) {
            this.id = node.getId();
            this.primaryType = node.getPrimaryType();
            this.mixinTypes = node.getMixinTypes();
        }

        public IdWithTypes(SimpleFragment hierFragment) throws StorageException {
            this.id = hierFragment.getId();
            this.primaryType = hierFragment.getString("primarytype");
            this.mixinTypes = (String[])hierFragment.get("mixintypes");
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(id=" + this.id + ",primaryType=" + this.primaryType + ",mixinTypes=" + Arrays.toString(this.mixinTypes) + ")";
        }
    }

    public static class RowBatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final List<Row> creates = new LinkedList<Row>();
        public final Set<RowUpdate> updates = new HashSet<RowUpdate>();
        public final Set<RowId> deletes = new HashSet<RowId>();
        public final Set<RowId> deletesDependent = new HashSet<RowId>();

        public boolean isEmpty() {
            return this.creates.isEmpty() && this.updates.isEmpty() && this.deletes.isEmpty() && this.deletesDependent.isEmpty();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(creates=" + this.creates + ", updates=" + this.updates + ", deletes=" + this.deletes + ", deletesDependent=" + this.deletesDependent + ')';
        }
    }

    public static final class RowUpdate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Row row;
        public final Collection<String> keys;

        public RowUpdate(Row row, Collection<String> keys) {
            this.row = row;
            this.keys = keys;
        }

        public int hashCode() {
            return this.row.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof RowUpdate) {
                return this.equal((RowUpdate)other);
            }
            return false;
        }

        private boolean equal(RowUpdate other) {
            return other.row.equals(this.row);
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.row + ", keys=" + this.keys + ')';
        }
    }
}

