/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.directory.AbstractDirectoryOperation;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.CreateEntries", category="Services", label="Creates directory entries", description="Creates directory entries. Entries are sent as a JSON array. Returning the created entries ids as a JSON array.")
public class CreateDirectoryEntries
extends AbstractDirectoryOperation {
    public static final String ID = "Directory.CreateEntries";
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Param(name="directoryName", required=true)
    protected String directoryName;
    @Param(name="entries", required=true)
    protected String jsonEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run() throws Exception {
        this.validateCanManageDirectories(this.ctx);
        ObjectMapper mapper = new ObjectMapper();
        List entries = (List)mapper.readValue(this.jsonEntries, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        ArrayList<String> ids = new ArrayList<String>();
        Session session = null;
        try {
            session = this.directoryService.open(this.directoryName);
            for (Map entry : entries) {
                DocumentModel doc = session.createEntry(entry);
                ids.add(doc.getId());
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, ids);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), "application/json");
    }
}

