/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.directory.AbstractDirectoryOperation;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.DeleteEntries", category="Services", label="Deletes directory entries", description="Deletes directory entries. Entries ids to delete are sent through a JSON array. Returns deleted entries id as a JSON array.")
public class DeleteDirectoryEntries
extends AbstractDirectoryOperation {
    public static final String ID = "Directory.DeleteEntries";
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="directoryName", required=true)
    protected String directoryName;
    @Param(name="entries", required=true)
    protected String jsonEntries;
    @Param(name="markObsolete", required=false)
    protected boolean markObsolete = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Blob run() throws Exception {
        this.validateCanManageDirectories(this.ctx);
        ObjectMapper mapper = new ObjectMapper();
        List entries = (List)mapper.readValue(this.jsonEntries, (TypeReference)new TypeReference<List<String>>(){});
        ArrayList<String> ids = new ArrayList<String>();
        Session session = null;
        try {
            session = this.directoryService.open(this.directoryName);
            for (String entryId : entries) {
                if (this.markObsolete) {
                    this.markObsoleteOrDelete(session, entryId);
                } else {
                    session.deleteEntry(entryId);
                }
                ids.add(entryId);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, ids);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), "application/json");
    }

    protected void markObsoleteOrDelete(Session session, String id) throws ClientException {
        Directory directory = this.directoryService.getDirectory(this.directoryName);
        String schemaName = directory.getSchema();
        Schema schema = this.schemaManager.getSchema(schemaName);
        if (schema.hasField("obsolete")) {
            DocumentModel entry = session.getEntry(id);
            if (entry != null) {
                entry.setProperty(schemaName, "obsolete", (Object)1);
                session.updateEntry(entry);
            }
        } else {
            session.deleteEntry(id);
        }
    }
}

