/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.application.ClassPathScanner;
import org.nuxeo.osgi.application.SharedClassLoader;

public class ClassPath
implements ClassPathScanner.Callback {
    protected final List<BundleFile> bundles = new ArrayList<BundleFile>();
    protected final List<BundleFile> jars = new ArrayList<BundleFile>();
    protected final List<BundleFile> nestedJars = new ArrayList<BundleFile>();
    protected final SharedClassLoader loader;
    protected final File nestedJARsDir;

    public ClassPath(SharedClassLoader loader, File nestedJARsDir) {
        this.loader = loader;
        this.nestedJARsDir = nestedJARsDir;
        nestedJARsDir.mkdirs();
    }

    public List<BundleFile> getBundles() {
        return this.bundles;
    }

    public List<BundleFile> getJars() {
        return this.jars;
    }

    public List<BundleFile> getNestedJars() {
        return this.nestedJars;
    }

    public void scan(List<File> files, boolean scanForNestedJARs, String[] blacklist) {
        new ClassPathScanner(this, scanForNestedJARs, blacklist).scan(files);
    }

    @Override
    public File handleBundle(BundleFile bf) {
        this.bundles.add(bf);
        this.loader.addURL(bf.getURL());
        return this.nestedJARsDir;
    }

    @Override
    public File handleJar(BundleFile bf) {
        this.jars.add(bf);
        this.loader.addURL(bf.getURL());
        return this.nestedJARsDir;
    }

    @Override
    public void handleNestedJar(BundleFile bf) {
        this.nestedJars.add(bf);
        this.loader.addURL(bf.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            for (BundleFile bf : this.bundles) {
                writer.append(bf.getFile().getAbsolutePath());
                writer.newLine();
            }
            writer.append("#");
            writer.newLine();
            for (BundleFile bf : this.jars) {
                writer.append(bf.getFile().getAbsolutePath());
                writer.newLine();
            }
            writer.append("#");
            writer.newLine();
            for (BundleFile bf : this.nestedJars) {
                writer.append(bf.getFile().getAbsolutePath());
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(File file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            List<BundleFile> list = this.bundles;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    if (list == this.bundles) {
                        list = this.jars;
                        continue;
                    }
                    if (list != this.jars) continue;
                    list = this.nestedJars;
                    continue;
                }
                BundleFile bf = null;
                File f = new File(line.trim());
                bf = f.isDirectory() ? new DirectoryBundleFile(f) : new JarBundleFile(f);
                this.loader.addURL(bf.getURL());
                list.add(bf);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

