/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.DatasourceConnectionProvider;
import org.nuxeo.runtime.api.ConnectionHelper;

public class NuxeoConnectionProvider
implements ConnectionProvider {
    protected DatasourceConnectionProvider dscp;
    protected String dataSourceName;

    public void configure(Properties props) throws HibernateException {
        this.dscp = new DatasourceConnectionProvider();
        this.dscp.configure(props);
        this.dataSourceName = props.getProperty("hibernate.connection.datasource");
    }

    public Connection getConnection() throws SQLException {
        Connection connection = ConnectionHelper.getConnection((String)this.dataSourceName);
        if (connection == null) {
            connection = this.dscp.getConnection();
        }
        return connection;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void close() throws HibernateException {
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

