/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.convert.collections;

import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.convert.IUnidirectionalConverter;
import com.phloc.commons.filter.IFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ContainerConversionHelper {
    private static final ContainerConversionHelper s_aInstance = new ContainerConversionHelper();

    private ContainerConversionHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        HashSet<DSTTYPE> hashSet = new HashSet<DSTTYPE>();
        while (iterator.hasNext()) {
            hashSet.add(iUnidirectionalConverter.convert(iterator.next()));
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        HashSet<DSTTYPE> hashSet = new HashSet<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            hashSet.add(iUnidirectionalConverter.convert(SRCTYPE));
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        HashSet<DSTTYPE> hashSet = new HashSet<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            if (!iFilter.matchesFilter(SRCTYPE)) continue;
            hashSet.add(iUnidirectionalConverter.convert(SRCTYPE));
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newSet(iterator, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newSet(iterable, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newSet(iterable, iFilter, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        LinkedHashSet<DSTTYPE> linkedHashSet = new LinkedHashSet<DSTTYPE>();
        while (iterator.hasNext()) {
            linkedHashSet.add(iUnidirectionalConverter.convert(iterator.next()));
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        LinkedHashSet<DSTTYPE> linkedHashSet = new LinkedHashSet<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            linkedHashSet.add(iUnidirectionalConverter.convert(SRCTYPE));
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        LinkedHashSet<DSTTYPE> linkedHashSet = new LinkedHashSet<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            if (!iFilter.matchesFilter(SRCTYPE)) continue;
            linkedHashSet.add(iUnidirectionalConverter.convert(SRCTYPE));
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(iterator, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(iterable, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(iterable, iFilter, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                arrayList.add(iUnidirectionalConverter.convert(SRCTYPE));
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>(ArrayHelper.getSize(SRCTYPEArray));
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                arrayList.add(iUnidirectionalConverter.convert(SRCTYPE));
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                if (!iFilter.matchesFilter(SRCTYPE)) continue;
                arrayList.add(iUnidirectionalConverter.convert(SRCTYPE));
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newList(iterable, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newList(SRCTYPEArray, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        return ContainerHelper.makeUnmodifiable(ContainerConversionHelper.newList(iterable, iFilter, iUnidirectionalConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> List<DSTTYPE> getSorted(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (iUnidirectionalConverter == null) {
            throw new NullPointerException("comparator");
        }
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        while (iterator.hasNext()) {
            arrayList.add(iUnidirectionalConverter.convert(iterator.next()));
        }
        return ContainerHelper.getSortedInline(arrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> getSorted(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter, @Nonnull Comparator<? super DSTTYPE> comparator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (iUnidirectionalConverter == null) {
            throw new NullPointerException("converter");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator");
        }
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        while (iterator.hasNext()) {
            arrayList.add(iUnidirectionalConverter.convert(iterator.next()));
        }
        return ContainerHelper.getSortedInline(arrayList, comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> List<DSTTYPE> getSorted(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        if (iterable == null) {
            throw new NullPointerException("container");
        }
        if (iUnidirectionalConverter == null) {
            throw new NullPointerException("converter");
        }
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            arrayList.add(iUnidirectionalConverter.convert(SRCTYPE));
        }
        return ContainerHelper.getSortedInline(arrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> getSorted(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter, @Nonnull Comparator<? super DSTTYPE> comparator) {
        if (iterable == null) {
            throw new NullPointerException("container");
        }
        if (iUnidirectionalConverter == null) {
            throw new NullPointerException("converter");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator");
        }
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            arrayList.add(iUnidirectionalConverter.convert(SRCTYPE));
        }
        return ContainerHelper.getSortedInline(arrayList, comparator);
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> Iterator<DSTTYPE> getIterator(final @Nonnull Iterable<SRCTYPE> iterable, final @Nonnull IUnidirectionalConverter<? super SRCTYPE, ? extends DSTTYPE> iUnidirectionalConverter) {
        if (iterable == null) {
            throw new NullPointerException("cont");
        }
        if (iUnidirectionalConverter == null) {
            throw new NullPointerException("converter");
        }
        return new Iterator<DSTTYPE>(){
            private final Iterator<SRCTYPE> m_aIT;
            {
                this.m_aIT = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.m_aIT.hasNext();
            }

            @Override
            public DSTTYPE next() {
                return iUnidirectionalConverter.convert(this.m_aIT.next());
            }

            @Override
            public void remove() {
                this.m_aIT.remove();
            }
        };
    }
}

