/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.search;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.search.api.client.SearchException;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultSet;
import org.nuxeo.ecm.core.search.api.client.search.results.document.SearchPageProvider;
import org.nuxeo.ecm.core.search.api.client.search.results.impl.ResultSetImpl;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.SortNotSupportedException;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.ecm.webapp.search.SearchActions;
import org.nuxeo.ecm.webapp.search.SearchType;

@Deprecated
@Name(value="searchActions")
@Scope(value=ScopeType.CONVERSATION)
public class SearchActionsBean
extends InputController
implements SearchActions,
Serializable {
    public static final String ACTION_PAGE_SEARCH_FORM = "search_form";
    public static final String ACTION_PAGE_SEARCH_RESULTS = "search_results";
    public static final String ACTION_PAGE_SEARCH_NO_KEYWORDS = null;
    public static final String ACTION_PAGE_SEARCH_QUERY_ERROR = null;
    private static final long serialVersionUID = -4020792436254971735L;
    private static final Log log = LogFactory.getLog(SearchActionsBean.class);
    @Deprecated
    public static final String QM_ADVANCED = "ADVANCED_SEARCH";
    @Deprecated
    public static final String QM_SIMPLE = "SIMPLE_SEARCH";
    @Deprecated
    public static final String PROV_NXQL = "SEARCH_BEAN_NXQL_PROVIDER";
    private static final String ACTION_PAGE_SEARCH_NXQL = "search_results_nxql";
    private static final String ACTION_PAGE_SEARCH_ADVANCED = "search_results_advanced";
    private static final String ACTION_PAGE_SEARCH_SIMPLE = "search_results_simple";
    @In(required=false)
    private transient Principal currentUser;
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @In(required=false, create=true)
    private transient DocumentsListsManager documentsListsManager;
    @In(required=false, create=true)
    private transient QueryModelActions queryModelActions;
    @In(required=false, create=true)
    private transient ResultsProvidersCache resultsProvidersCache;
    @In(required=false, create=true)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    private transient ClipboardActions clipboardActions;
    @In(create=true)
    private transient Context conversationContext;
    private String queryErrorMsg;
    private String nxql;
    private String simpleSearchKeywords = "";
    private String reindexPath = "";
    private SearchType searchTypeId = SearchType.KEYWORDS;
    private static final int maxResultsCount = 10;

    @BypassInterceptors
    public String getSimpleSearchKeywords() {
        return this.simpleSearchKeywords;
    }

    public void setSimpleSearchKeywords(String k) {
        this.simpleSearchKeywords = k;
    }

    public String getNxql() {
        return this.nxql;
    }

    public void setNxql(String k) {
        this.nxql = k;
    }

    @BypassInterceptors
    public String getSearchTypeId() {
        return this.searchTypeId.name();
    }

    public void setSearchTypeId(String type) {
        this.searchTypeId = SearchType.valueOf((String)type);
    }

    public String getReindexPath() {
        return this.reindexPath;
    }

    public void setReindexPath(String path) {
        this.reindexPath = path;
    }

    @RequestParameter(value="searchType")
    public void setSearchType(String type) {
        if (null == type) {
            return;
        }
        this.searchTypeId = SearchType.valueOf((String)type);
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetSearchField() {
        this.simpleSearchKeywords = "";
        this.searchTypeId = SearchType.KEYWORDS;
    }

    public String getQueryErrorMsg() {
        return this.queryErrorMsg;
    }

    public void setQueryErrorMsg(String msg) {
        this.queryErrorMsg = msg;
    }

    @Begin(join=true)
    public String search() {
        this.queryErrorMsg = "";
        return ACTION_PAGE_SEARCH_FORM;
    }

    public String getLatestNxql() {
        return (String)this.conversationContext.get("search.lastQuery");
    }

    public String performSearch() {
        Events evtManager = Events.instance();
        log.debug((Object)"Fire Event: searchPerformed");
        evtManager.raiseEvent("searchPerformed", new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("performing searchType: " + this.searchTypeId));
        }
        try {
            String page;
            PagedDocumentsProvider resultsProvider;
            if (this.searchTypeId == SearchType.NXQL) {
                if (this.nxql == null) {
                    log.warn((Object)"Direct NXQL search: no nxql query has been provided");
                    return ACTION_PAGE_SEARCH_NO_KEYWORDS;
                }
                log.debug((Object)("Query: " + this.nxql));
                this.resultsProvidersCache.invalidate(PROV_NXQL);
                resultsProvider = this.resultsProvidersCache.get(PROV_NXQL);
                page = ACTION_PAGE_SEARCH_NXQL;
            } else if (this.searchTypeId == SearchType.FORM) {
                this.resultsProvidersCache.invalidate(QM_ADVANCED);
                resultsProvider = this.resultsProvidersCache.get(QM_ADVANCED, null);
                page = ACTION_PAGE_SEARCH_ADVANCED;
            } else if (this.searchTypeId == SearchType.KEYWORDS) {
                String[] keywords;
                if (this.simpleSearchKeywords == null || this.simpleSearchKeywords == "") {
                    log.warn((Object)"simpleSearchKeywords not given");
                    this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.search.noKeywords"), new Object[0]);
                    return ACTION_PAGE_SEARCH_NO_KEYWORDS;
                }
                for (String keyword : keywords = this.simpleSearchKeywords.split(" ")) {
                    if (!keyword.startsWith("*")) continue;
                    log.warn((Object)"Can't begin search with * character");
                    this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.search.star"), new Object[0]);
                    return ACTION_PAGE_SEARCH_NO_KEYWORDS;
                }
                this.resultsProvidersCache.invalidate(QM_SIMPLE);
                resultsProvider = this.resultsProvidersCache.get(QM_SIMPLE);
                page = ACTION_PAGE_SEARCH_SIMPLE;
            } else {
                throw new ClientException("Unknown search type: " + this.searchTypeId);
            }
            if (resultsProvider instanceof SearchPageProvider) {
                String lastQuery = ((SearchPageProvider)resultsProvider).getQuery();
                this.conversationContext.set("search.lastQuery", (Object)lastQuery);
            } else {
                this.conversationContext.set("search.lastQuery", null);
            }
            return page;
        }
        catch (SortNotSupportedException e) {
            this.queryErrorMsg = e.getMessage();
            log.debug((Object)("Search error: " + e.getMessage()), (Throwable)e);
            return ACTION_PAGE_SEARCH_QUERY_ERROR;
        }
        catch (ClientException e) {
            this.queryErrorMsg = e.getMessage();
            log.debug((Object)("Search error: " + e.getMessage()), (Throwable)e);
            return ACTION_PAGE_SEARCH_QUERY_ERROR;
        }
    }

    public List<DocumentModel> getResultDocuments(String providerName) throws ClientException {
        PagedDocumentsProvider provider = this.resultsProvidersCache.get(providerName);
        if (provider == null) {
            log.warn((Object)"resultsProvider not available for getResultDocuments");
            return new ArrayList<DocumentModel>();
        }
        return provider.getCurrentPage();
    }

    @Deprecated
    public String getDocumentLocation(DocumentModel doc) {
        Object[] titles;
        DocumentRef parentRef = doc.getParentRef();
        try {
            titles = this.documentManager.getDataModelsFieldUp(parentRef, "dublincore", "title");
        }
        catch (ClientException e) {
            log.error((Object)e);
            return null;
        }
        StringBuilder location = new StringBuilder();
        for (int i = titles.length - 2; i >= 0; --i) {
            Object title = titles[i];
            location.append('/');
            location.append(title);
        }
        if (titles.length == 1) {
            location.append('/');
        }
        return location.toString();
    }

    public SelectDataModel getResultsSelectModel(String providerName) throws ClientException {
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        SelectDataModelImpl model = new SelectDataModelImpl("SEARCH_DOCUMENT_LIST", this.getResultDocuments(providerName), selectedDocuments);
        model.addSelectModelListener((SelectDataModelListener)this);
        return model;
    }

    @WebRemote
    public String processSelectRow(String selectedDocRef, String providerName, Boolean selection) throws ClientException {
        DocumentModel data = null;
        List<DocumentModel> currentDocs = this.getResultDocuments(providerName);
        for (DocumentModel doc : currentDocs) {
            DocumentRef docRef = doc.getRef();
            if (docRef == null) {
                log.error((Object)("null DocumentRef for doc: " + doc));
                continue;
            }
            if (!docRef.reference().equals(selectedDocRef)) continue;
            data = doc;
            break;
        }
        if (data == null) {
            return "ERROR : DataNotFound";
        }
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", data);
        }
        return this.computeSelectionActions();
    }

    private String computeSelectionActions() {
        List availableActions = this.clipboardActions.getActionsForSelection();
        ArrayList<String> availableActionIds = new ArrayList<String>();
        for (Action a : availableActions) {
            if (!a.getAvailable()) continue;
            availableActionIds.add(a.getId());
        }
        String res = "";
        if (!availableActionIds.isEmpty()) {
            res = StringUtils.join((Object[])availableActionIds.toArray(), (String)"|");
        }
        return res;
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", data);
        }
    }

    @Factory(value="searchDocumentModel", scope=ScopeType.EVENT)
    public DocumentModel getDocumentModel() throws ClientException {
        return this.queryModelActions.get(QM_ADVANCED).getDocumentModel();
    }

    @Deprecated
    public void reindexDocuments() throws ClientException {
        this.reindexDocuments(this.reindexPath);
    }

    @Deprecated
    public void reindexDocuments(String path) throws ClientException {
    }

    public String reset() throws ClientException {
        this.queryModelActions.reset(QM_ADVANCED);
        return null;
    }

    public PagedDocumentsProvider getResultsProvider(String name) throws ClientException, ResultsProviderFarmUserException {
        return this.getResultsProvider(name, null);
    }

    public PagedDocumentsProvider getResultsProvider(String name, SortInfo sortInfo) throws ClientException, ResultsProviderFarmUserException {
        try {
            switch (this.searchTypeId) {
                case NXQL: {
                    if (sortInfo != null) {
                        throw new SortNotSupportedException();
                    }
                    ResultSet resultSet = new ResultSetImpl(this.nxql, this.documentManager, 0, 10, Collections.emptyList(), 0, 0).replay();
                    SearchPageProvider nxqlProvider = new SearchPageProvider(resultSet, false, null, this.nxql);
                    nxqlProvider.setName(name);
                    return nxqlProvider;
                }
                case KEYWORDS: {
                    Object[] sK = new Object[]{this.simpleSearchKeywords};
                    QueryModel qm = this.queryModelActions.get(QM_SIMPLE);
                    PagedDocumentsProvider simpleProvider = qm.getResultsProvider(this.documentManager, sK, sortInfo);
                    simpleProvider.setName(name);
                    return simpleProvider;
                }
            }
            throw new ClientException("UNknown search type");
        }
        catch (SearchException e) {
            throw new ClientException("Error while performing search", (Throwable)e);
        }
        catch (QueryParseException e) {
            throw new ResultsProviderFarmUserException("label.search.service.wrong.query", (Throwable)e);
        }
    }

    @Observer(value={"documentChildrenChanged"}, create=false)
    public void refreshCache() {
        this.resultsProvidersCache.invalidate(QM_SIMPLE);
        this.resultsProvidersCache.invalidate(QM_ADVANCED);
        this.resultsProvidersCache.invalidate(PROV_NXQL);
    }

    public boolean isReindexingAll() {
        return false;
    }
}

