/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.factories;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.runtime.api.Framework;

public class ThumbnailDocumentFactory
implements ThumbnailFactory {
    private static final Log log = LogFactory.getLog(ThumbnailDocumentFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getThumbnail(DocumentModel doc, CoreSession session) throws ClientException {
        Blob thumbnailBlob = null;
        try {
            if (doc.hasFacet("Thumbnail")) {
                thumbnailBlob = (Blob)doc.getPropertyValue("thumb:thumbnail");
            }
        }
        catch (ClientException e) {
            log.warn((Object)"Could not fetch the thumbnail blob", (Throwable)e);
        }
        finally {
            if (thumbnailBlob == null) {
                TypeInfo docType = (TypeInfo)doc.getAdapter(TypeInfo.class);
                thumbnailBlob = new FileBlob(FileUtils.getResourceFileFromContext((String)("nuxeo.war" + File.separator + docType.getBigIcon())));
            }
        }
        return thumbnailBlob;
    }

    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        Blob thumbnailBlob = null;
        try {
            ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", "100");
                bh = conversionService.convert("thumbnailDocumentConverter", bh, params);
                if (bh != null) {
                    thumbnailBlob = bh.getBlob();
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Cannot compute document thumbnail", (Throwable)e);
        }
        return thumbnailBlob;
    }
}

