/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.listener;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.thumbnail.AddThumbnailUnrestricted;
import org.nuxeo.ecm.platform.thumbnail.ThumbnailConstants;

public class UpdateThumbnailListener
implements PostCommitEventListener {
    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext context;
        DocumentModel doc;
        BlobHolder blobHolder;
        EventContext ec = event.getContext();
        if (ec instanceof DocumentEventContext && (event.getName().equals("documentCreated") || event.getName().equals(ThumbnailConstants.EventNames.afterBlobUpdateCheck.name())) && (blobHolder = (BlobHolder)(doc = (context = (DocumentEventContext)ec).getSourceDocument()).getAdapter(BlobHolder.class)) != null) {
            try {
                AddThumbnailUnrestricted runner = new AddThumbnailUnrestricted(context.getCoreSession(), doc, blobHolder);
                runner.run();
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void handleEvent(EventBundle events) throws ClientException {
        if (!events.containsEventName("documentCreated") && !events.containsEventName(ThumbnailConstants.EventNames.afterBlobUpdateCheck.name())) {
            return;
        }
        for (Event event : events) {
            if (!"documentCreated".equals(event.getName()) && !ThumbnailConstants.EventNames.afterBlobUpdateCheck.name().equals(event.getName())) continue;
            this.handleEvent(event);
        }
    }
}

