/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingPersister;
import org.nuxeo.ecm.platform.routing.core.persistence.TreeHelper;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class DocumentRoutingTreePersister
implements DocumentRoutingPersister {
    private static final String DC_TITLE = "dc:title";
    protected static final Log log = LogFactory.getLog(DocumentRoutingTreePersister.class);

    public DocumentModel getParentFolderForDocumentRouteInstance(DocumentModel document, CoreSession session) {
        try {
            return TreeHelper.getOrCreateDateTreeFolder(session, this.getOrCreateRootOfDocumentRouteInstanceStructure(session), new Date(), "Folder");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public DocumentModel createDocumentRouteInstanceFromDocumentRouteModel(DocumentModel model, CoreSession session) {
        DocumentModel parent = this.getParentFolderForDocumentRouteInstance(model, session);
        DocumentModel result = null;
        try {
            result = session.copy(model.getRef(), parent.getRef(), null);
            result = this.undoReadOnlySecurityPolicy(result, session);
            NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
            String initiator = principal.getOriginatingUser();
            if (initiator == null) {
                initiator = principal.getName();
            }
            result.setPropertyValue("docri:initiator", (Serializable)((Object)initiator));
            result.setPropertyValue("docri:participatingDocuments", model.getPropertyValue("docri:participatingDocuments"));
            result.setPropertyValue("dc:created", (Serializable)Calendar.getInstance());
            session.saveDocument(result);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return result;
    }

    public DocumentModel saveDocumentRouteInstanceAsNewModel(DocumentModel routeInstance, DocumentModel parentFolder, String newName, CoreSession session) {
        DocumentModel result = null;
        try {
            result = session.copy(routeInstance.getRef(), parentFolder.getRef(), newName);
            return this.undoReadOnlySecurityPolicy(result, session);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public DocumentModel getOrCreateRootOfDocumentRouteInstanceStructure(CoreSession session) {
        try {
            DocumentModel root = this.getDocumentRoutesStructure("DocumentRouteInstancesRoot", session);
            if (root == null) {
                root = this.createDocumentRoutesStructure("DocumentRouteInstancesRoot", "document-route-instances-root", session);
            }
            return root;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected DocumentModel createDocumentRoutesStructure(String routeStructureDocType, String id, CoreSession session) throws ClientException {
        String query = "SELECT * FROM Domain WHERE ecm:parentId = '%s' AND ecm:currentLifeCycleState <> 'deleted' AND ecm:mixinType <> 'HiddenInNavigation' ORDER BY ecm:name";
        query = String.format(query, session.getRootDocument().getId());
        DocumentModelList docs = session.query(query, 1);
        DocumentModel defaultDomain = (DocumentModel)docs.get(0);
        DocumentModel root = session.createDocumentModel(defaultDomain.getPathAsString(), id, routeStructureDocType);
        root.setPropertyValue(DC_TITLE, (Serializable)((Object)routeStructureDocType));
        root = session.createDocument(root);
        ACP acp = session.getACP(root.getRef());
        ACL acl = acp.getOrCreateACL("local");
        acl.addAll(this.getACEs());
        session.setACP(root.getRef(), acp, true);
        return root;
    }

    protected DocumentModel createModelsRoutesStructure(String routeStructureDocType, String id, CoreSession session) throws ClientException {
        DocumentModel rootModels = session.createDocumentModel("/", id, routeStructureDocType);
        rootModels.setPropertyValue(DC_TITLE, (Serializable)((Object)routeStructureDocType));
        rootModels = session.createDocument(rootModels);
        ACP acp = session.getACP(rootModels.getRef());
        ACL acl = acp.getOrCreateACL("local");
        acl.add((Object)new ACE("Everyone", "Read", true));
        session.setACP(rootModels.getRef(), acp, true);
        return rootModels;
    }

    protected List<ACE> getACEs() {
        ArrayList<ACE> aces = new ArrayList<ACE>();
        for (String group : this.getUserManager().getAdministratorsGroups()) {
            aces.add(new ACE(group, "Everything", true));
        }
        aces.add(new ACE("routeManagers", "ReadWrite", true));
        aces.add(new ACE("Everyone", "Everything", false));
        return aces;
    }

    protected UserManager getUserManager() {
        try {
            return (UserManager)Framework.getService(UserManager.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected DocumentModel getDocumentRoutesStructure(String type, CoreSession session) throws ClientException {
        DocumentModelList res = session.query(String.format("SELECT * from %s", type));
        if (res == null || res.isEmpty()) {
            return null;
        }
        if (res.size() > 1 && log.isWarnEnabled()) {
            log.warn((Object)"More han one DocumentRouteInstanceRoot found:");
            for (DocumentModel model : res) {
                log.warn((Object)(" - " + model.getName() + ", " + model.getPathAsString()));
            }
        }
        return (DocumentModel)res.get(0);
    }

    public DocumentModel getParentFolderForNewModel(CoreSession session, DocumentModel instance) {
        try {
            UserWorkspaceService service = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
            return service.getCurrentUserPersonalWorkspace(session, instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getNewModelName(DocumentModel instance) {
        try {
            return "(COPY) " + instance.getPropertyValue(DC_TITLE);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    protected DocumentModel undoReadOnlySecurityPolicy(DocumentModel instance, CoreSession session) throws ClientException {
        UndoReadOnlySecurityPolicy runner = new UndoReadOnlySecurityPolicy(session, instance.getRef());
        runner.runUnrestricted();
        return session.getDocument(runner.getInstanceRef());
    }

    public DocumentModel getParentFolderForDocumentRouteModels(CoreSession session) {
        try {
            DocumentModel root = this.getDocumentRoutesStructure("DocumentRouteModelsRoot", session);
            if (root == null) {
                root = this.createModelsRoutesStructure("DocumentRouteModelsRoot", "document-route-models-root", session);
            }
            return root;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    class UndoReadOnlySecurityPolicy
    extends UnrestrictedSessionRunner {
        DocumentRef documentRef;

        public UndoReadOnlySecurityPolicy(CoreSession session, DocumentRef documentRef) {
            super(session);
            this.documentRef = documentRef;
        }

        public void run() throws ClientException {
            DocumentModel instance = this.session.getDocument(this.documentRef);
            if (instance == null) {
                return;
            }
            ACP acp = instance.getACP();
            ACL routingACL = acp.getOrCreateACL("routing");
            routingACL.remove((Object)new ACE("Everyone", "Read", true));
            ACL localACL = acp.getOrCreateACL("local");
            localACL.remove((Object)new ACE("Everyone", "Everything", false));
            instance.setACP(acp, true);
        }

        DocumentRef getInstanceRef() {
            return this.documentRef;
        }
    }
}

