/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.mistral;

import com.drew.imaging.jpeg.JpegProcessingException;
import it.tidalwave.image.EditableImage;
import it.tidalwave.image.Rational;
import it.tidalwave.image.metadata.EXIFDirectory;
import it.tidalwave.image.op.ReadOp;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.picture.ExifHelper;
import org.nuxeo.ecm.platform.picture.IPTCHelper;
import org.nuxeo.ecm.platform.picture.core.MetadataUtils;

public class MistralMetadataUtils
implements MetadataUtils {
    private static final Log log = LogFactory.getLog(MistralMetadataUtils.class);
    private static final String JPEG_MIMETYPE = "image/jpeg";

    @Override
    public Map<String, Object> getImageMetadata(Blob blob) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        try {
            String copyright;
            String equipment;
            String comment;
            String description;
            EditableImage image = EditableImage.create((ReadOp)new ReadOp((Object)blob.getStream(), ReadOp.Type.METADATA));
            EXIFDirectory exif = image.getEXIFDirectory();
            image = EditableImage.create((ReadOp)new ReadOp((Object)blob.getStream()));
            metadata.put("width", image.getWidth());
            metadata.put("height", image.getHeight());
            if (exif.isImageDescriptionAvailable() && (description = exif.getImageDescription().trim()).length() > 0) {
                metadata.put("description", description);
            }
            if (exif.isUserCommentAvailable() && (comment = ExifHelper.decodeUndefined(exif.getUserComment()).trim()).length() > 0) {
                metadata.put("comment", comment);
            }
            if ((exif.isMakeAvailable() || exif.isModelAvailable()) && (equipment = (exif.getMake() + " " + exif.getModel()).trim()).length() > 0) {
                metadata.put("equipment", equipment);
            }
            if (exif.isDateTimeOriginalAvailable()) {
                metadata.put("originalDate", exif.getDateTimeOriginalAsDate());
            }
            if (exif.isXResolutionAvailable() && exif.isYResolutionAvailable()) {
                metadata.put("horizontalResolution", exif.getXResolution().intValue());
                metadata.put("verticalResolution", exif.getYResolution().intValue());
            }
            if (exif.isPixelXDimensionAvailable() && exif.isPixelYDimensionAvailable()) {
                metadata.put("pixelXDimension", exif.getPixelXDimension());
                metadata.put("pixelYDimension", exif.getPixelYDimension());
            }
            if (exif.isCopyrightAvailable() && (copyright = exif.getCopyright().trim()).length() > 0) {
                metadata.put("copyright", copyright);
            }
            if (exif.isExposureTimeAvailable()) {
                Rational exposure = exif.getExposureTime();
                int n = exposure.getNumerator();
                int d = exposure.getDenominator();
                if (d >= n && d % n == 0) {
                    exposure = new Rational(1, d / n);
                }
                metadata.put("exposure", exposure.toString());
            }
            if (exif.isISOSpeedRatingsAvailable()) {
                metadata.put("ISOspeed", "ISO-" + exif.getISOSpeedRatings());
            }
            if (exif.isFocalLengthAvailable()) {
                metadata.put("focalLength", exif.getFocalLength().doubleValue());
            }
            if (exif.isColorSpaceAvailable()) {
                metadata.put("colorSpace", exif.getColorSpace().toString());
            }
            if (exif.isWhiteBalanceAvailable()) {
                metadata.put("whiteBalance", exif.getWhiteBalance().toString().toLowerCase());
            }
            if (exif.isInterColourProfileAvailable()) {
                metadata.put("iccProfile", exif.getICCProfile());
            }
            if (exif.isOrientationAvailable()) {
                metadata.put("orientation", exif.getOrientation().toString());
            }
            if (exif.isFNumberAvailable()) {
                metadata.put("fNumber", exif.getFNumber().doubleValue());
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to get EXIF metadata for the file:" + blob.getFilename()), (Throwable)e);
        }
        try {
            if (JPEG_MIMETYPE.equals(blob.getMimeType())) {
                IPTCHelper.extractMetadata(blob.getStream(), metadata);
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to get IPTC metadata for the file:" + blob.getFilename()), (Throwable)e);
        }
        catch (JpegProcessingException e) {
            log.error((Object)("Failed to get IPTC metadata for the file:" + blob.getFilename()), (Throwable)e);
        }
        return metadata;
    }
}

