/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.listener;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.PictureViewsGenerationWork;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;

public class PictureChangedListener
implements EventListener {
    public static final String EMPTY_PICTURE_PATH = "nuxeo.war/img/empty_picture.png";
    private static final Log log = LogFactory.getLog(PictureChangedListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("Picture")) {
            Property fileProp = doc.getProperty("file:content");
            Property viewsProp = doc.getProperty("picture:views");
            if (fileProp.isDirty()) {
                if (viewsProp == null || !viewsProp.isDirty()) {
                    this.preFillPictureViews(docCtx.getCoreSession(), doc);
                    PictureViewsGenerationWork work = new PictureViewsGenerationWork(doc.getRepositoryName(), doc.getRef());
                    WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
                    workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
                }
            } else if (fileProp.getValue() == null) {
                this.preFillPictureViews(docCtx.getCoreSession(), doc);
            }
        }
    }

    protected void preFillPictureViews(CoreSession session, DocumentModel doc) {
        try {
            FileBlob blob = new FileBlob(FileUtils.getResourceFileFromContext((String)this.getEmptyPicturePath()));
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
            String mimeType = mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), (Blob)blob, null);
            blob.setMimeType(mimeType);
            DocumentModel parentDoc = this.getParentDocument(session, doc);
            ArrayList pictureTemplates = null;
            if (parentDoc != null && "PictureBook".equals(parentDoc.getType()) && (pictureTemplates = (ArrayList)parentDoc.getPropertyValue("picturebook:picturetemplates")).isEmpty()) {
                pictureTemplates = null;
            }
            PictureResourceAdapter adapter = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
            adapter.preFillPictureViews((Blob)blob, pictureTemplates);
        }
        catch (Exception e) {
            log.error((Object)("Error while : " + e.getMessage()));
        }
    }

    protected String getEmptyPicturePath() {
        return EMPTY_PICTURE_PATH;
    }

    protected DocumentModel getParentDocument(CoreSession session, DocumentModel doc) throws ClientException {
        DocumentModel parent;
        if (session.exists(doc.getRef())) {
            parent = session.getParentDocument(doc.getRef());
        } else {
            Path parentPath = doc.getPath().removeLastSegments(1);
            parent = session.getDocument((DocumentRef)new PathRef(parentPath.toString()));
        }
        return parent;
    }
}

