/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.io.streams.NonBlockingBufferedReader;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.ServiceLoaderException;
import com.phloc.commons.string.ToStringGenerator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoaderBackport<SPITYPE>
implements Iterable<SPITYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ServiceLoaderBackport.class);
    private static final String PREFIX = "META-INF/services/";
    private final Class<SPITYPE> m_aService;
    private final ClassLoader m_aClassLoader;
    private final Map<String, SPITYPE> m_aProviders = new LinkedHashMap<String, SPITYPE>();
    private LazyIterator m_aLookupIterator;

    public void reload() {
        this.m_aProviders.clear();
        this.m_aLookupIterator = new LazyIterator(this.m_aService, this.m_aClassLoader);
    }

    private ServiceLoaderBackport(Class<SPITYPE> clazz, ClassLoader classLoader) {
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Loading all SPI implementations of " + clazz.toString());
        }
        this.m_aService = clazz;
        this.m_aClassLoader = classLoader;
        this.reload();
    }

    private static void _fail(Class<?> clazz, String string, Throwable throwable) {
        throw new ServiceLoaderException(clazz.getName() + ": " + string, throwable);
    }

    private static void _fail(Class<?> clazz, String string) {
        throw new ServiceLoaderException(clazz.getName() + ": " + string);
    }

    private static void _fail(Class<?> clazz, URL uRL, int n, String string) {
        throw new ServiceLoaderException(clazz.getName() + ": " + uRL + ":" + n + ": " + string);
    }

    private int _parseLine(Class<SPITYPE> clazz, URL uRL, NonBlockingBufferedReader nonBlockingBufferedReader, int n, List<String> list) throws IOException {
        int n2;
        String string = nonBlockingBufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            int n4;
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                ServiceLoaderBackport._fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(n4 = string.codePointAt(0))) {
                ServiceLoaderBackport._fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            for (int i = Character.charCount(n4); i < n2; i += Character.charCount(n4)) {
                n4 = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n4) || n4 == 46) continue;
                ServiceLoaderBackport._fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            if (!this.m_aProviders.containsKey(string) && !list.contains(string)) {
                list.add(string);
            }
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> _parse(Class<SPITYPE> clazz, URL uRL) {
        InputStream inputStream = null;
        NonBlockingBufferedReader nonBlockingBufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            inputStream = uRL.openStream();
            nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamUtils.createReader(inputStream, "UTF-8"));
            int n = 1;
            while ((n = this._parseLine(clazz, uRL, nonBlockingBufferedReader, n, arrayList)) >= 0) {
            }
        }
        catch (IOException iOException) {
            ServiceLoaderBackport._fail(clazz, "Error reading configuration file", iOException);
        }
        finally {
            try {
                if (nonBlockingBufferedReader != null) {
                    nonBlockingBufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                ServiceLoaderBackport._fail(clazz, "Error closing configuration file", iOException);
            }
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<SPITYPE> iterator() {
        return new Iterator<SPITYPE>(){
            private final Iterator<Map.Entry<String, SPITYPE>> m_aKnownProviders;
            {
                this.m_aKnownProviders = ServiceLoaderBackport.this.m_aProviders.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.m_aKnownProviders.hasNext()) {
                    return true;
                }
                return ServiceLoaderBackport.this.m_aLookupIterator.hasNext();
            }

            @Override
            public SPITYPE next() {
                if (this.m_aKnownProviders.hasNext()) {
                    return this.m_aKnownProviders.next().getValue();
                }
                return ServiceLoaderBackport.this.m_aLookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return new ToStringGenerator(this).append("serviceName", this.m_aService.getName()).toString();
    }

    public static <S> ServiceLoaderBackport<S> load(Class<S> clazz, ClassLoader classLoader) {
        return new ServiceLoaderBackport<S>(clazz, classLoader);
    }

    public static <S> ServiceLoaderBackport<S> load(Class<S> clazz) {
        return ServiceLoaderBackport.load(clazz, ClassHelper.getDefaultClassLoader());
    }

    public static <S> ServiceLoaderBackport<S> loadInstalled(Class<S> clazz) {
        ClassLoader classLoader = null;
        for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            classLoader = classLoader2;
        }
        return ServiceLoaderBackport.load(clazz, classLoader);
    }

    @SuppressFBWarnings(value={"UWF_NULL_FIELD"})
    private final class LazyIterator
    implements Iterator<SPITYPE> {
        private final Class<SPITYPE> m_aLIService;
        private final ClassLoader m_aLILoader;
        private Enumeration<URL> m_aLIConfigs = null;
        private Iterator<String> m_aLIPending = null;
        private String m_sLINextName = null;

        public LazyIterator(Class<SPITYPE> clazz, ClassLoader classLoader) {
            this.m_aLIService = clazz;
            this.m_aLILoader = classLoader;
        }

        @Override
        public boolean hasNext() {
            if (this.m_sLINextName != null) {
                return true;
            }
            if (this.m_aLIConfigs == null) {
                try {
                    String string = ServiceLoaderBackport.PREFIX + this.m_aLIService.getName();
                    this.m_aLIConfigs = this.m_aLILoader == null ? ClassLoader.getSystemResources(string) : this.m_aLILoader.getResources(string);
                }
                catch (IOException iOException) {
                    ServiceLoaderBackport._fail(this.m_aLIService, "Error locating configuration files", iOException);
                }
            }
            while (this.m_aLIPending == null || !this.m_aLIPending.hasNext()) {
                if (!this.m_aLIConfigs.hasMoreElements()) {
                    return false;
                }
                this.m_aLIPending = ServiceLoaderBackport.this._parse(this.m_aLIService, this.m_aLIConfigs.nextElement());
            }
            this.m_sLINextName = this.m_aLIPending.next();
            return true;
        }

        @Override
        public SPITYPE next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.m_sLINextName;
            this.m_sLINextName = null;
            try {
                Object SPITYPE = this.m_aLIService.cast(Class.forName(string, true, this.m_aLILoader).newInstance());
                ServiceLoaderBackport.this.m_aProviders.put(string, SPITYPE);
                return SPITYPE;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ServiceLoaderBackport._fail(this.m_aLIService, "Provider " + string + " not found");
            }
            catch (Throwable throwable) {
                ServiceLoaderBackport._fail(this.m_aLIService, "Provider " + string + " could not be instantiated: " + throwable, throwable);
            }
            throw new Error();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

