/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.RandomAccessLongList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayUnsignedIntList
extends RandomAccessLongList
implements Serializable {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    private transient int[] _data;
    private int _size;

    public ArrayUnsignedIntList() {
        this(8);
    }

    public ArrayUnsignedIntList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new int[n];
        this._size = 0;
    }

    public ArrayUnsignedIntList(@Nonnull LongCollection longCollection) {
        this(longCollection.size());
        this.addAll(longCollection);
    }

    public ArrayUnsignedIntList(@Nonnull long[] lArray) {
        this(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            this._data[i] = this._fromLong(lArray[i]);
        }
        this._size = lArray.length;
    }

    @Override
    public long get(int n) {
        this._checkRange(n);
        return this._toLong(this._data[n]);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public long removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        long l = this._toLong(this._data[n]);
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return l;
    }

    @Override
    public long set(int n, long l) {
        this._assertValidUnsignedInt(l);
        this._checkRange(n);
        this.incrModCount();
        long l2 = this._toLong(this._data[n]);
        this._data[n] = this._fromLong(l);
        return l2;
    }

    @Override
    public void add(int n, long l) {
        this._assertValidUnsignedInt(l);
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = this._fromLong(l);
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            int[] nArray = this._data;
            this._data = new int[n2 < n ? n : n2];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            int[] nArray = this._data;
            this._data = new int[this._size];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    private final long _toLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private final int _fromLong(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    private final void _assertValidUnsignedInt(long l) throws IllegalArgumentException {
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(l + " > " + 0xFFFFFFFFL);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(l + " < " + 0L);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeInt(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new int[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readInt();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

