/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteList;
import org.apache.commons.collections.primitives.adapters.AbstractByteCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ByteListIteratorListIterator;
import org.apache.commons.collections.primitives.adapters.ByteListList;
import org.apache.commons.collections.primitives.adapters.CollectionByteCollection;

abstract class AbstractByteListList
extends AbstractByteCollectionCollection
implements List<Byte> {
    AbstractByteListList() {
    }

    @Nonnull
    protected abstract ByteList getByteList();

    @Override
    @Nonnull
    protected final ByteCollection getByteCollection() {
        return this.getByteList();
    }

    @Override
    public void add(int n, @Nonnull Byte by) {
        this.getByteList().add(n, by);
    }

    @Override
    public boolean addAll(int n, Collection<? extends Byte> collection) {
        return this.getByteList().addAll(n, CollectionByteCollection.wrap(collection));
    }

    @Override
    @Nonnull
    public Byte get(int n) {
        return this.getByteList().get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.getByteList().indexOf((Byte)object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getByteList().lastIndexOf((Byte)object);
    }

    @Override
    public ListIterator<Byte> listIterator() {
        return ByteListIteratorListIterator.wrap(this.getByteList().listIterator());
    }

    @Override
    public ListIterator<Byte> listIterator(int n) {
        return ByteListIteratorListIterator.wrap(this.getByteList().listIterator(n));
    }

    @Override
    @Nonnull
    public Byte remove(int n) {
        return this.getByteList().removeElementAt(n);
    }

    @Override
    @Nonnull
    public Byte set(int n, Byte by) {
        return this.getByteList().set(n, by);
    }

    @Override
    public List<Byte> subList(int n, int n2) {
        return ByteListList.wrap(this.getByteList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator<Byte> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            Byte by = iterator.next();
            Object e = iterator2.next();
            if (!(null == by ? null != e : !((Object)by).equals(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getByteList()).hashCode();
    }
}

