/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.FloatListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionFloatCollection;
import org.apache.commons.collections.primitives.adapters.FloatCollectionCollection;
import org.apache.commons.collections.primitives.adapters.ListFloatList;
import org.apache.commons.collections.primitives.adapters.ListIteratorFloatListIterator;

abstract class AbstractListFloatList
extends AbstractCollectionFloatCollection
implements FloatList {
    AbstractListFloatList() {
    }

    @Override
    @Nonnull
    protected final Collection<Float> getCollection() {
        return this.getList();
    }

    @Nonnull
    protected abstract List<Float> getList();

    @Override
    public void add(int n, float f) {
        this.getList().add(n, Float.valueOf(f));
    }

    @Override
    public boolean addAll(int n, @Nonnull FloatCollection floatCollection) {
        return this.getList().addAll(n, FloatCollectionCollection.wrap(floatCollection));
    }

    @Override
    public float get(int n) {
        return this.getList().get(n).floatValue();
    }

    @Override
    public int indexOf(float f) {
        return this.getList().indexOf(Float.valueOf(f));
    }

    @Override
    public int lastIndexOf(float f) {
        return this.getList().lastIndexOf(Float.valueOf(f));
    }

    @Override
    @Nonnull
    public FloatListIterator listIterator() {
        return ListIteratorFloatListIterator.wrap(this.getList().listIterator());
    }

    @Override
    @Nonnull
    public FloatListIterator listIterator(int n) {
        return ListIteratorFloatListIterator.wrap(this.getList().listIterator(n));
    }

    @Override
    public float removeElementAt(int n) {
        return this.getList().remove(n).floatValue();
    }

    @Override
    public float set(int n, float f) {
        return this.getList().set(n, Float.valueOf(f)).floatValue();
    }

    @Override
    @Nonnull
    public FloatList subList(int n, int n2) {
        return ListFloatList.wrap(this.getList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatList)) {
            return false;
        }
        FloatList floatList = (FloatList)object;
        if (this.size() != floatList.size()) {
            return false;
        }
        FloatIterator floatIterator = this.iterator();
        FloatIterator floatIterator2 = floatList.iterator();
        while (floatIterator.hasNext()) {
            if (floatIterator.next() == floatIterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }
}

