/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.annotea;

import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.annotations.gwt.client.annotea.Statement;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Container;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointerFactory;

public class RDFParser {
    private static final String r = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String nx = "http://www.nuxeo.org/document/uid/";

    public List<Annotation> getAnnotationList(String response) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Document document = XMLParser.parse((String)response);
        Node root = document.getElementsByTagName("RDF").item(0);
        NodeList nodeList = root.getChildNodes();
        for (int x = 0; x < nodeList.getLength(); ++x) {
            Annotation annotation = this.processAnnotation(nodeList.item(x));
            if (annotation == null) continue;
            result.add(annotation);
        }
        return result;
    }

    public Annotation processAnnotation(Node item) {
        if (item == null || item.getNamespaceURI() == null || item.getNodeName() == null) {
            return null;
        }
        if (item.getNamespaceURI().equals(r) && item.getNodeName().endsWith(":Description")) {
            String about = item.getAttributes().item(0).getNodeValue();
            String annotationUUID = about.substring(about.lastIndexOf(":") + 1);
            return this.getAnnotation(annotationUUID, item.getChildNodes());
        }
        return null;
    }

    public Annotation getAnnotation(String annotationUUID, NodeList list) {
        Annotation annotation = new Annotation(annotationUUID);
        HashMap<String, Statement> map = new HashMap<String, Statement>();
        HashMap<String, String> fields = new HashMap<String, String>();
        for (int x = 0; x < list.getLength(); ++x) {
            Node node = list.item(x);
            if (node.getNodeName().equals("#text") || node.getNodeType() != 1) continue;
            if (node.getNamespaceURI().equals(nx)) {
                String nodeName = node.getNodeName();
                String name = nodeName.substring(nodeName.indexOf(":") + 1);
                if ("startContainer".equals(name)) {
                    annotation.setStartContainer(Container.fromString(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if ("endContainer".equals(name)) {
                    annotation.setEndContainer(Container.fromString(node.getFirstChild().getNodeValue()));
                    continue;
                }
                fields.put(name, node.getFirstChild().getNodeValue());
                continue;
            }
            Statement statement = new Statement(node);
            if (statement.getObject().equals("http://www.w3.org/2000/10/annotation-ns#Annotation")) continue;
            map.put(statement.getPredicate(), statement);
        }
        annotation.setType(((Statement)map.get("{http://www.w3.org/1999/02/22-rdf-syntax-ns#}type")).getObject());
        XPointer xpointer = XPointerFactory.getXPointer(((Statement)map.get("{http://www.w3.org/2000/10/annotation-ns#}context")).getObject());
        annotation.setXpointer(xpointer);
        if (map.containsKey("{http://www.w3.org/1999/xx/http#}Body")) {
            Statement s = (Statement)map.get("{http://www.w3.org/1999/xx/http#}Body");
            annotation.setBody(this.parseXMLLiteralForBody(s.getObject()));
        } else {
            Statement bodyStatement = (Statement)map.get("{http://www.w3.org/2000/10/annotation-ns#}body");
            annotation.setBody(bodyStatement.getObject());
            if (bodyStatement.isResource()) {
                annotation.setBodyUrl(true);
            }
        }
        if (map.get("{http://purl.org/dc/elements/1.1/}creator") != null && ((Statement)map.get("{http://purl.org/dc/elements/1.1/}creator")).getObject() != null) {
            annotation.setAuthor(((Statement)map.get("{http://purl.org/dc/elements/1.1/}creator")).getObject());
        }
        if (map.get("{http://purl.org/dc/elements/1.1/}date") != null && ((Statement)map.get("{http://purl.org/dc/elements/1.1/}date")).getObject() != null) {
            annotation.setStringDate(((Statement)map.get("{http://purl.org/dc/elements/1.1/}date")).getObject());
        }
        for (Map.Entry entry : map.entrySet()) {
            fields.put((String)entry.getKey(), ((Statement)entry.getValue()).getObject());
        }
        annotation.setFields(fields);
        return annotation;
    }

    private String parseXMLLiteralForBody(String html) {
        if (html.contains("<body>")) {
            String body = "<body>";
            int beginIndex = html.indexOf(body) + body.length();
            int endIndex = html.indexOf("</body>");
            return html.substring(beginIndex, endIndex);
        }
        if (html.contains("&lt;body&gt;")) {
            String body = "&lt;body&gt;";
            int beginIndex = html.indexOf(body) + body.length();
            int endIndex = html.indexOf("&lt;/body&gt;");
            return html.substring(beginIndex, endIndex);
        }
        return "";
    }
}

