/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.configuration;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationDefinition;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationFilter;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.filter.AnnotationDefinitionFilter;

public class WebConfiguration
implements IsSerializable {
    public static final WebConfiguration DEFAULT_WEB_CONFIGURATION = new WebConfiguration();
    private Map<String, AnnotationDefinition> annotationDefinitions = new HashMap<String, AnnotationDefinition>();
    private Map<String, String> userInfo = new HashMap<String, String>();
    private List<AnnotationFilter> filters = new ArrayList<AnnotationFilter>();
    private Set<String> displayedFields = new HashSet<String>();
    private Map<String, String> fieldLabels;
    private boolean canAnnotate = true;

    public void addAnnotationDefinition(AnnotationDefinition annotationDefinition) {
        this.annotationDefinitions.put(annotationDefinition.getName(), annotationDefinition);
    }

    public void removeAnnotationDefinition(AnnotationDefinition annotationDefinition) {
        this.annotationDefinitions.remove(annotationDefinition);
    }

    public List<AnnotationDefinition> getAnnotationDefinitions() {
        ArrayList<AnnotationDefinition> list = new ArrayList<AnnotationDefinition>(this.annotationDefinitions.values());
        return Collections.unmodifiableList(list);
    }

    public List<AnnotationDefinition> getAnnotationDefinitions(AnnotationDefinitionFilter filter) {
        ArrayList<AnnotationDefinition> types = new ArrayList<AnnotationDefinition>();
        for (AnnotationDefinition type : this.annotationDefinitions.values()) {
            if (!filter.accept(type)) continue;
            types.add(type);
        }
        return types;
    }

    public Map<String, AnnotationDefinition> getAnnotationDefinitionsMap() {
        return this.annotationDefinitions;
    }

    public AnnotationDefinition getAnnotationDefinition(String name) {
        AnnotationDefinition def = this.annotationDefinitions.get(name);
        return def != null ? def : this.getFirsTannotationDefinition();
    }

    private AnnotationDefinition getFirsTannotationDefinition() {
        ArrayList<AnnotationDefinition> l = new ArrayList<AnnotationDefinition>(this.annotationDefinitions.values());
        return l.isEmpty() ? null : (AnnotationDefinition)l.get(0);
    }

    public void setUserInfo(Map<String, String> userInfo) {
        this.userInfo = userInfo;
    }

    public Map<String, String> getUserInfo() {
        return this.userInfo;
    }

    private String getValue(String v) {
        if (v != null && v.startsWith("${") && v.endsWith("}")) {
            v = this.userInfo.get(v.substring(2, v.length() - 1));
        }
        return v;
    }

    public void addFilter(int order, String name, String icon, String type, String author, Map<String, String> fields) {
        HashMap<String, String> newFields = new HashMap<String, String>();
        for (String fieldName : fields.keySet()) {
            String value = this.getValue(fields.get(fieldName));
            if (value == null) continue;
            newFields.put(fieldName, value);
        }
        if (order < this.filters.size()) {
            this.filters.add(order, new AnnotationFilter(name, icon, this.getValue(type), this.getValue(author), newFields));
        } else {
            this.filters.add(new AnnotationFilter(name, icon, this.getValue(type), this.getValue(author), newFields));
        }
    }

    public List<AnnotationFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<AnnotationFilter> filters) {
        this.filters = filters;
    }

    public Set<String> getDisplayedFields() {
        return this.displayedFields;
    }

    public void setDisplayedFields(Set<String> fields) {
        this.displayedFields = fields;
    }

    public void setFieldLabels(Map<String, String> fieldLabels) {
        this.fieldLabels = fieldLabels;
    }

    public Map<String, String> getFieldLabels() {
        return this.fieldLabels;
    }

    public void setCanAnnotate(boolean canAnnotate) {
        this.canAnnotate = canAnnotate;
    }

    public boolean canAnnotate() {
        return this.canAnnotate;
    }

    static {
        DEFAULT_WEB_CONFIGURATION.addAnnotationDefinition(new AnnotationDefinition("http://www.w3.org/2000/10/annotationType#Example", "Example", "icons/annotate.png", "local"));
        DEFAULT_WEB_CONFIGURATION.addAnnotationDefinition(new AnnotationDefinition("http://www.w3.org/2000/10/annotationType#Comment", "Comment", "icons/annotate.png", "local"));
        DEFAULT_WEB_CONFIGURATION.addAnnotationDefinition(new AnnotationDefinition("http://www.w3.org/2000/10/annotationType#SeeAlso", "SeeAlso", "icons/annotate.png", "local"));
        DEFAULT_WEB_CONFIGURATION.addAnnotationDefinition(new AnnotationDefinition("http://www.w3.org/2000/10/annotationType#Question", "Question", "icons/annotate.png", "local"));
        DEFAULT_WEB_CONFIGURATION.addAnnotationDefinition(new AnnotationDefinition("http://www.w3.org/2000/10/annotationType#Explanation", "Explanation", "icons/annotate.png", "local"));
        DEFAULT_WEB_CONFIGURATION.addAnnotationDefinition(new AnnotationDefinition("http://www.w3.org/2000/10/annotationType#Change", "Change", "icons/annotate.png", "local"));
        DEFAULT_WEB_CONFIGURATION.addAnnotationDefinition(new AnnotationDefinition("http://www.w3.org/2000/10/annotationType#Advice", "Advice", "icons/annotate.png", "local"));
    }
}

