/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.PropertyContainer;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBaseProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;

public class SQLComplexProperty
extends SQLBaseProperty
implements PropertyContainer {
    private static final Log log = LogFactory.getLog(SQLComplexProperty.class);
    private final Node node;

    public SQLComplexProperty(Node node, ComplexType type, SQLDocument doc) {
        super((Type)type, node == null ? null : node.getName(), doc);
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.node.getName();
    }

    public Object getValue() throws DocumentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Collection<Property> properties = this.getProperties();
        for (Property property : properties) {
            map.put(property.getName(), property.getValue());
        }
        return map;
    }

    public void setValue(Object value) throws DocumentException {
        this.checkWritable();
        if (value == null) {
            for (Property property : this.getProperties()) {
                property.setValue(null);
            }
        } else {
            if (!(value instanceof Map)) {
                throw new DocumentException("Invalid value for complex property (map needed): " + value);
            }
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Property property = this.getProperty((String)entry.getKey());
                property.setValue(entry.getValue());
            }
        }
    }

    @Override
    public boolean isPropertySet(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property getProperty(String name) throws DocumentException {
        return this.getSession().makeProperty(this.node, name, (ComplexType)this.type, this.getDocument(), null, null);
    }

    @Override
    public Collection<Property> getProperties() throws DocumentException {
        Collection fields = ((ComplexType)this.type).getFields();
        ArrayList<Property> properties = new ArrayList<Property>(fields.size());
        for (Field field : fields) {
            properties.add(this.getProperty(field.getName().getPrefixedName()));
        }
        return properties;
    }

    @Override
    public Iterator<Property> getPropertyIterator() throws DocumentException {
        return this.getProperties().iterator();
    }

    public Map<String, Object> exportFlatMap(String[] schemas) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Map<String, Object>> exportMap(String[] schemas) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> exportMap(String schemaName) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void importFlatMap(Map<String, Object> map) throws DocumentException {
        this.checkWritable();
        throw new UnsupportedOperationException();
    }

    public void importMap(Map<String, Map<String, Object>> map) throws DocumentException {
        this.checkWritable();
        throw new UnsupportedOperationException();
    }

    public List<String> getDirtyFields() {
        throw new UnsupportedOperationException();
    }

    public Object getPropertyValue(String name) throws DocumentException {
        return this.getProperty(name).getValue();
    }

    public String getString(String name) throws DocumentException {
        return (String)this.getProperty(name).getValue();
    }

    public boolean getBoolean(String name) throws DocumentException {
        Boolean value = (Boolean)this.getProperty(name).getValue();
        return value == null ? false : value;
    }

    public long getLong(String name) throws DocumentException {
        Long value = (Long)this.getProperty(name).getValue();
        return value == null ? 0L : value;
    }

    public double getDouble(String name) throws DocumentException {
        Double value = (Double)this.getProperty(name).getValue();
        return value == null ? 0.0 : value;
    }

    public Calendar getDate(String name) throws DocumentException {
        return (Calendar)this.getProperty(name).getValue();
    }

    public Blob getContent(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void setPropertyValue(String name, Object value) throws DocumentException {
        try {
            this.getProperty(name).setValue(value);
        }
        catch (DocumentException e) {
            log.debug((Object)("Error setting property: " + name + " value: " + value));
            throw e;
        }
    }

    public void setString(String name, String value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setBoolean(String name, boolean value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setLong(String name, long value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setDouble(String name, double value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setDate(String name, Calendar value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setContent(String name, Blob value) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void removeProperty(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }
}

