/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.reload;

import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryManager;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;

public class RepositoryReloader
implements EventListener {
    private static Log log = LogFactory.getLog(RepositoryReloader.class);

    public boolean aboutToHandleEvent(Event event) {
        return true;
    }

    public void handleEvent(Event event) {
        String id = event.getId();
        if ("reloadRepositories".equals(id) || "flush".equals(id)) {
            try {
                RepositoryReloader.reloadRepositories();
            }
            catch (Exception e) {
                log.error((Object)"Failed to reload repositories", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Repository> getRepositories() throws NamingException {
        LinkedList<Repository> list = new LinkedList<Repository>();
        InitialContext context = new InitialContext();
        for (String prefix : new String[]{"java:NXRepository", "NXRepository"}) {
            NamingEnumeration<Binding> bindings;
            try {
                bindings = context.listBindings(prefix);
            }
            catch (NamingException e) {
                continue;
            }
            try (NamingEnumeration<Binding> e = null;){
                e = bindings;
                while (e.hasMore()) {
                    Object object;
                    Binding binding = (Binding)e.nextElement();
                    String name = binding.getName();
                    if (binding.isRelative()) {
                        name = prefix + '/' + name;
                    }
                    if (!((object = context.lookup(name)) instanceof Repository)) continue;
                    list.add((Repository)object);
                }
            }
        }
        return list;
    }

    public static void closeRepositories() throws Exception {
        List<Repository> repos = RepositoryReloader.getRepositories();
        if (!repos.isEmpty()) {
            for (Repository repository : repos) {
                repository.shutdown();
            }
        } else {
            RepositoryManager mgr = NXCore.getRepositoryService().getRepositoryManager();
            for (String name : mgr.getRepositoryNames()) {
                Repository repo = mgr.getRepository(name);
                repo.shutdown();
            }
        }
    }

    public static MBeanServer locateJBoss() {
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            if (!server.getDefaultDomain().equals("jboss")) continue;
            return server;
        }
        return null;
    }

    public static void flushJCAPool() throws Exception {
        MBeanServer jboss = RepositoryReloader.locateJBoss();
        if (jboss != null) {
            jboss.invoke(new ObjectName("jboss.jca:name=NXRepository/default,service=ManagedConnectionPool"), "flush", new Object[0], new String[0]);
        } else {
            Class<?> cl = null;
            try {
                cl = Class.forName("org.nuxeo.runtime.jtajca.NuxeoContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (cl != null) {
                cl.getMethod("resetConnectionManager", new Class[0]).invoke(null, new Object[0]);
            }
        }
    }

    public static void reloadRepositories() throws Exception {
        RepositoryReloader.flushJCAPool();
        RepositoryReloader.closeRepositories();
    }
}

