/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WorkHolder
implements Runnable {
    private final Work work;

    public WorkHolder(Work work) {
        this.work = work;
    }

    public static Work getWork(Runnable r) {
        return ((WorkHolder)r).work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.work.isSuspending()) {
            this.work.suspended();
            return;
        }
        TransactionHelper.startTransaction();
        WorkSchedulePath.handleEnter(this.work);
        boolean ok = false;
        Exception exc = null;
        try {
            this.work.setStartTime();
            this.work.work();
            ok = true;
        }
        catch (Exception e) {
            exc = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            WorkSchedulePath.handleReturn();
            try {
                this.work.cleanUp(ok, exc);
            }
            finally {
                try {
                    if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                        if (!ok) {
                            TransactionHelper.setTransactionRollbackOnly();
                        }
                        TransactionHelper.commitOrRollbackTransaction();
                    }
                }
                finally {
                    if (exc instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

