/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.graph.FrontsTriple;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.util.iterator.Map1;

public interface Statement
extends FrontsTriple {
    public boolean equals(Object var1);

    public int hashCode();

    public Resource getSubject();

    public Property getPredicate();

    public RDFNode getObject();

    public Statement getProperty(Property var1);

    public Statement getStatementProperty(Property var1);

    public Resource getResource();

    public Literal getLiteral();

    public boolean getBoolean();

    public byte getByte();

    public short getShort();

    public int getInt();

    public long getLong();

    public char getChar();

    public float getFloat();

    public double getDouble();

    public String getString();

    @Deprecated
    public Resource getResource(ResourceF var1);

    public Bag getBag();

    public Alt getAlt();

    public Seq getSeq();

    public String getLanguage();

    public boolean hasWellFormedXML();

    public Statement changeLiteralObject(boolean var1);

    public Statement changeLiteralObject(long var1);

    public Statement changeLiteralObject(int var1);

    public Statement changeLiteralObject(char var1);

    public Statement changeLiteralObject(float var1);

    public Statement changeLiteralObject(double var1);

    public Statement changeObject(String var1);

    public Statement changeObject(String var1, boolean var2);

    public Statement changeObject(String var1, String var2);

    public Statement changeObject(String var1, String var2, boolean var3);

    public Statement changeObject(RDFNode var1);

    public Statement remove();

    public boolean isReified();

    public ReifiedStatement createReifiedStatement();

    public ReifiedStatement createReifiedStatement(String var1);

    public RSIterator listReifiedStatements();

    public Model getModel();

    public void removeReification();

    public static class Util {
        public static final Map1<Statement, Resource> getSubject = new Map1<Statement, Resource>(){

            @Override
            public Resource map1(Statement o) {
                return o.getSubject();
            }
        };
        public static final Map1<Statement, Property> getPredicate = new Map1<Statement, Property>(){

            @Override
            public Property map1(Statement o) {
                return o.getPredicate();
            }
        };
        public static final Map1<Statement, RDFNode> getObject = new Map1<Statement, RDFNode>(){

            @Override
            public RDFNode map1(Statement o) {
                return o.getObject();
            }
        };
    }
}

