/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.util.Pipeline;
import java.util.Collections;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsolidateCodeStage
implements Pipeline.Stage<Jobs> {
    @Override
    public boolean apply(Jobs jobs) {
        Block initFunctionBody = new Block(FilePosition.UNKNOWN, Collections.emptyList());
        MutableParseTreeNode.Mutation mut = initFunctionBody.createMutation();
        ListIterator<Job> it = jobs.getJobs().listIterator();
        while (it.hasNext()) {
            Job job = it.next();
            if (Job.JobType.JAVASCRIPT != job.getType()) continue;
            Statement stmt = (Statement)job.getRoot().node;
            if (stmt instanceof Block) {
                Block body = (Block)stmt;
                MutableParseTreeNode.Mutation old = body.createMutation();
                for (Statement statement : body.children()) {
                    old.removeChild(statement);
                    mut.appendChild(statement);
                }
                old.execute();
            } else {
                mut.appendChild(stmt);
            }
            it.remove();
        }
        mut.execute();
        UncajoledModule envelope = new UncajoledModule(initFunctionBody);
        jobs.getJobs().add(new Job(AncestorChain.instance(envelope)));
        return jobs.hasNoFatalErrors();
    }
}

